/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client.support;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.SocketFactory;
import org.apache.geode.cache.query.QueryService;
import org.springframework.data.gemfire.client.support.FactoryDefaultsPoolAdapter;

public abstract class DelegatingPoolAdapter
extends FactoryDefaultsPoolAdapter {
    private final Pool delegate;

    public static DelegatingPoolAdapter from(Pool delegate) {
        return new DelegatingPoolAdapter(delegate){};
    }

    public DelegatingPoolAdapter(Pool delegate) {
        this.delegate = delegate;
    }

    protected Pool getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isDestroyed() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::isDestroyed).orElseGet(() -> super.isDestroyed());
    }

    @Override
    public int getFreeConnectionTimeout() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getFreeConnectionTimeout).orElseGet(() -> super.getFreeConnectionTimeout());
    }

    @Override
    public long getIdleTimeout() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getIdleTimeout).orElseGet(() -> super.getIdleTimeout());
    }

    @Override
    public int getLoadConditioningInterval() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getLoadConditioningInterval).orElseGet(() -> super.getLoadConditioningInterval());
    }

    @Override
    public List<InetSocketAddress> getLocators() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getLocators).orElseGet(() -> super.getLocators());
    }

    @Override
    public int getMaxConnections() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getMaxConnections).orElseGet(() -> super.getMaxConnections());
    }

    @Override
    public int getMinConnections() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getMinConnections).orElseGet(() -> super.getMinConnections());
    }

    @Override
    public boolean getMultiuserAuthentication() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getMultiuserAuthentication).orElseGet(() -> super.getMultiuserAuthentication());
    }

    @Override
    public String getName() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getName).orElseGet(() -> super.getName());
    }

    @Override
    public List<InetSocketAddress> getOnlineLocators() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getOnlineLocators).orElseGet(() -> super.getOnlineLocators());
    }

    @Override
    public int getPendingEventCount() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getPendingEventCount).orElse(0);
    }

    @Override
    public long getPingInterval() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getPingInterval).orElseGet(() -> super.getPingInterval());
    }

    @Override
    public boolean getPRSingleHopEnabled() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getPRSingleHopEnabled).orElseGet(() -> super.getPRSingleHopEnabled());
    }

    @Override
    public QueryService getQueryService() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getQueryService).orElseGet(() -> super.getQueryService());
    }

    @Override
    public int getReadTimeout() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getReadTimeout).orElseGet(() -> super.getReadTimeout());
    }

    @Override
    public int getRetryAttempts() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getRetryAttempts).orElseGet(() -> super.getRetryAttempts());
    }

    @Override
    public int getServerConnectionTimeout() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getServerConnectionTimeout).orElseGet(() -> super.getServerConnectionTimeout());
    }

    @Override
    public String getServerGroup() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getServerGroup).orElseGet(() -> super.getServerGroup());
    }

    @Override
    public List<InetSocketAddress> getServers() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getServers).orElseGet(() -> super.getServers());
    }

    @Override
    public int getSocketBufferSize() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getSocketBufferSize).orElseGet(() -> super.getSocketBufferSize());
    }

    @Override
    public int getSocketConnectTimeout() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getSocketConnectTimeout).orElseGet(() -> super.getSocketConnectTimeout());
    }

    @Override
    public SocketFactory getSocketFactory() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getSocketFactory).orElseGet(() -> super.getSocketFactory());
    }

    @Override
    public int getStatisticInterval() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getStatisticInterval).orElseGet(() -> super.getStatisticInterval());
    }

    @Override
    public int getSubscriptionAckInterval() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getSubscriptionAckInterval).orElseGet(() -> super.getSubscriptionAckInterval());
    }

    @Override
    public boolean getSubscriptionEnabled() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getSubscriptionEnabled).orElseGet(() -> super.getSubscriptionEnabled());
    }

    @Override
    public int getSubscriptionMessageTrackingTimeout() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getSubscriptionMessageTrackingTimeout).orElseGet(() -> super.getSubscriptionMessageTrackingTimeout());
    }

    @Override
    public int getSubscriptionRedundancy() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getSubscriptionRedundancy).orElseGet(() -> super.getSubscriptionRedundancy());
    }

    @Override
    public int getSubscriptionTimeoutMultiplier() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getSubscriptionTimeoutMultiplier).orElseGet(() -> super.getSubscriptionTimeoutMultiplier());
    }

    @Override
    public boolean getThreadLocalConnections() {
        return Optional.ofNullable(this.getDelegate()).map(Pool::getThreadLocalConnections).orElseGet(() -> super.getThreadLocalConnections());
    }

    @Override
    public void destroy() {
        Optional.ofNullable(this.getDelegate()).ifPresent(Pool::destroy);
    }

    @Override
    public void destroy(boolean keepAlive) {
        Optional.ofNullable(this.getDelegate()).ifPresent(delegate -> delegate.destroy(keepAlive));
    }

    @Override
    public void releaseThreadLocalConnection() {
        Optional.ofNullable(this.getDelegate()).ifPresent(Pool::releaseThreadLocalConnection);
    }
}

