/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.schema.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.gemfire.config.schema.SchemaObjectDefiner;
import org.springframework.data.gemfire.config.schema.SchemaObjectDefinition;
import org.springframework.data.gemfire.config.schema.SchemaObjectType;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.Nullable;

public final class ComposableSchemaObjectDefiner
implements SchemaObjectDefiner,
Iterable<SchemaObjectDefiner> {
    private final Set<SchemaObjectDefiner> schemaObjectDefiners;

    @Nullable
    public static SchemaObjectDefiner compose(SchemaObjectDefiner ... schemaObjectDefiners) {
        return ComposableSchemaObjectDefiner.compose(Arrays.asList(ArrayUtils.nullSafeArray(schemaObjectDefiners, SchemaObjectDefiner.class)));
    }

    @Nullable
    public static SchemaObjectDefiner compose(Iterable<SchemaObjectDefiner> schemaObjectDefiners) {
        Set<SchemaObjectDefiner> schemaObjectDefinerSet = StreamSupport.stream(CollectionUtils.nullSafeIterable(schemaObjectDefiners).spliterator(), false).filter(Objects::nonNull).collect(Collectors.toSet());
        return schemaObjectDefinerSet.isEmpty() ? null : (schemaObjectDefinerSet.size() == 1 ? (SchemaObjectDefiner)schemaObjectDefinerSet.iterator().next() : new ComposableSchemaObjectDefiner(schemaObjectDefinerSet));
    }

    private ComposableSchemaObjectDefiner(Set<SchemaObjectDefiner> schemaObjectDefiners) {
        this.schemaObjectDefiners = Collections.unmodifiableSet(schemaObjectDefiners);
    }

    @Override
    public Set<SchemaObjectType> getSchemaObjectTypes() {
        return this.schemaObjectDefiners.stream().flatMap(it -> it.getSchemaObjectTypes().stream()).collect(Collectors.toSet());
    }

    @Override
    public Optional<? extends SchemaObjectDefinition> define(Object schemaObject) {
        return this.schemaObjectDefiners.stream().filter(it -> it.canDefine(schemaObject)).findAny().map(it -> it.define(schemaObject).orElse(null));
    }

    @Override
    public Iterator<SchemaObjectDefiner> iterator() {
        return Collections.unmodifiableSet(this.schemaObjectDefiners).iterator();
    }
}

