/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.geode.GemFireCheckedException;
import org.apache.geode.GemFireException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.pdx.PdxSerializer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Phased;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.GemfireSystemException;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractBasicCacheFactoryBean
extends AbstractFactoryBeanSupport<GemFireCache>
implements DisposableBean,
InitializingBean,
PersistenceExceptionTranslator,
Phased {
    private boolean close = true;
    private int phase = -1;
    private Boolean copyOnRead;
    private Boolean pdxIgnoreUnreadFields;
    private Boolean pdxPersistent;
    private Boolean pdxReadSerialized;
    private CacheFactoryInitializer<?> cacheFactoryInitializer;
    private Float criticalHeapPercentage;
    private Float criticalOffHeapPercentage;
    private Float evictionHeapPercentage;
    private Float evictionOffHeapPercentage;
    private volatile GemFireCache cache;
    private List<TransactionListener> transactionListeners;
    private PdxSerializer pdxSerializer;
    private String pdxDiskStoreName;
    private TransactionWriter transactionWriter;

    protected void setCache(@Nullable GemFireCache cache) {
        this.cache = cache;
    }

    @Nullable
    public <T extends GemFireCache> T getCache() {
        return (T)this.cache;
    }

    public <T extends GemFireCache> Optional<T> getOptionalCache() {
        return Optional.ofNullable(this.getCache());
    }

    public void setCacheFactoryInitializer(@Nullable CacheFactoryInitializer cacheFactoryInitializer) {
        this.cacheFactoryInitializer = cacheFactoryInitializer;
    }

    @Nullable
    public CacheFactoryInitializer getCacheFactoryInitializer() {
        return this.cacheFactoryInitializer;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean isClose() {
        return this.close;
    }

    public void setCopyOnRead(@Nullable Boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    @Nullable
    public Boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    public boolean isCopyOnRead() {
        return Boolean.TRUE.equals(this.getCopyOnRead());
    }

    public void setCriticalHeapPercentage(@Nullable Float criticalHeapPercentage) {
        this.criticalHeapPercentage = criticalHeapPercentage;
    }

    public Float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    public void setCriticalOffHeapPercentage(@Nullable Float criticalOffHeapPercentage) {
        this.criticalOffHeapPercentage = criticalOffHeapPercentage;
    }

    public Float getCriticalOffHeapPercentage() {
        return this.criticalOffHeapPercentage;
    }

    public void setEvictionHeapPercentage(Float evictionHeapPercentage) {
        this.evictionHeapPercentage = evictionHeapPercentage;
    }

    public Float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    public void setEvictionOffHeapPercentage(Float evictionOffHeapPercentage) {
        this.evictionOffHeapPercentage = evictionOffHeapPercentage;
    }

    public Float getEvictionOffHeapPercentage() {
        return this.evictionOffHeapPercentage;
    }

    public GemFireCache getObject() throws Exception {
        Object cache = this.getCache();
        return cache != null ? cache : this.doGetObject();
    }

    protected abstract GemFireCache doGetObject();

    public Class<? extends GemFireCache> getObjectType() {
        Object cache = this.getCache();
        return cache != null ? cache.getClass() : this.doGetObjectType();
    }

    protected Class<? extends GemFireCache> doGetObjectType() {
        return GemFireCache.class;
    }

    public void setPdxDiskStoreName(@Nullable String pdxDiskStoreName) {
        this.pdxDiskStoreName = pdxDiskStoreName;
    }

    @Nullable
    public String getPdxDiskStoreName() {
        return this.pdxDiskStoreName;
    }

    public void setPdxIgnoreUnreadFields(@Nullable Boolean pdxIgnoreUnreadFields) {
        this.pdxIgnoreUnreadFields = pdxIgnoreUnreadFields;
    }

    @Nullable
    public Boolean getPdxIgnoreUnreadFields() {
        return this.pdxIgnoreUnreadFields;
    }

    public void setPdxPersistent(@Nullable Boolean pdxPersistent) {
        this.pdxPersistent = pdxPersistent;
    }

    @Nullable
    public Boolean getPdxPersistent() {
        return this.pdxPersistent;
    }

    public void setPdxReadSerialized(@Nullable Boolean pdxReadSerialized) {
        this.pdxReadSerialized = pdxReadSerialized;
    }

    @Nullable
    public Boolean getPdxReadSerialized() {
        return this.pdxReadSerialized;
    }

    public void setPdxSerializer(@Nullable PdxSerializer serializer) {
        this.pdxSerializer = serializer;
    }

    @Nullable
    public PdxSerializer getPdxSerializer() {
        return this.pdxSerializer;
    }

    protected void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setTransactionListeners(List<TransactionListener> transactionListeners) {
        this.transactionListeners = transactionListeners;
    }

    public List<TransactionListener> getTransactionListeners() {
        return CollectionUtils.nullSafeList(this.transactionListeners);
    }

    public void setTransactionWriter(@Nullable TransactionWriter transactionWriter) {
        this.transactionWriter = transactionWriter;
    }

    @Nullable
    public TransactionWriter getTransactionWriter() {
        return this.transactionWriter;
    }

    public void afterPropertiesSet() throws Exception {
        this.applyCacheConfigurers();
    }

    protected abstract void applyCacheConfigurers();

    protected void close(@Nullable GemFireCache cache) {
        Optional.ofNullable(cache).filter(this::isNotClosed).ifPresent(RegionService::close);
        this.setCache(null);
    }

    protected boolean isNotClosed(@Nullable GemFireCache cache) {
        return cache != null && !cache.isClosed();
    }

    public void destroy() {
        if (this.isClose()) {
            this.close((GemFireCache)this.fetchCache());
        }
    }

    private boolean isHeapPercentageValid(@NonNull Float heapPercentage) {
        return heapPercentage.floatValue() >= 0.0f && heapPercentage.floatValue() <= 100.0f;
    }

    @NonNull
    protected GemFireCache configureHeapPercentages(@NonNull GemFireCache cache) {
        Optional.ofNullable(this.getCriticalHeapPercentage()).ifPresent(criticalHeapPercentage -> {
            Assert.isTrue((boolean)this.isHeapPercentageValid((Float)criticalHeapPercentage), () -> String.format("criticalHeapPercentage [%s] is not valid; must be >= 0.0 and <= 100.0", criticalHeapPercentage));
            cache.getResourceManager().setCriticalHeapPercentage(criticalHeapPercentage.floatValue());
        });
        Optional.ofNullable(this.getEvictionHeapPercentage()).ifPresent(evictionHeapPercentage -> {
            Assert.isTrue((boolean)this.isHeapPercentageValid((Float)evictionHeapPercentage), () -> String.format("evictionHeapPercentage [%s] is not valid; must be >= 0.0 and <= 100.0", evictionHeapPercentage));
            cache.getResourceManager().setEvictionHeapPercentage(evictionHeapPercentage.floatValue());
        });
        return cache;
    }

    @NonNull
    protected GemFireCache configureOffHeapPercentages(@NonNull GemFireCache cache) {
        Optional.ofNullable(this.getCriticalOffHeapPercentage()).ifPresent(criticalOffHeapPercentage -> {
            Assert.isTrue((boolean)this.isHeapPercentageValid((Float)criticalOffHeapPercentage), () -> String.format("criticalOffHeapPercentage [%s] is not valid; must be >= 0.0 and <= 100.0", criticalOffHeapPercentage));
            cache.getResourceManager().setCriticalOffHeapPercentage(criticalOffHeapPercentage.floatValue());
        });
        Optional.ofNullable(this.getEvictionOffHeapPercentage()).ifPresent(evictionOffHeapPercentage -> {
            Assert.isTrue((boolean)this.isHeapPercentageValid((Float)evictionOffHeapPercentage), () -> String.format("evictionOffHeapPercentage [%s] is not valid; must be >= 0.0 and <= 100.0", evictionOffHeapPercentage));
            cache.getResourceManager().setEvictionOffHeapPercentage(evictionOffHeapPercentage.floatValue());
        });
        return cache;
    }

    protected <T> T configurePdx(PdxConfigurer<T> pdxConfigurer) {
        Optional.ofNullable(this.getPdxDiskStoreName()).filter(StringUtils::hasText).ifPresent(pdxConfigurer::setDiskStoreName);
        Optional.ofNullable(this.getPdxIgnoreUnreadFields()).ifPresent(pdxConfigurer::setIgnoreUnreadFields);
        Optional.ofNullable(this.getPdxPersistent()).ifPresent(pdxConfigurer::setPersistent);
        Optional.ofNullable(this.getPdxReadSerialized()).ifPresent(pdxConfigurer::setReadSerialized);
        Optional.ofNullable(this.getPdxSerializer()).ifPresent(pdxConfigurer::setSerializer);
        return pdxConfigurer.getTarget();
    }

    protected <T extends GemFireCache> T fetchCache() {
        T cache = this.getCache();
        return cache != null ? cache : this.doFetchCache();
    }

    protected abstract <T extends GemFireCache> T doFetchCache();

    @Nullable
    protected Object initializeFactory(Object factory) {
        return Optional.ofNullable(this.getCacheFactoryInitializer()).map(cacheFactoryInitializer -> cacheFactoryInitializer.initialize(factory)).orElse(factory);
    }

    @NonNull
    protected GemFireCache registerTransactionListeners(@NonNull GemFireCache cache) {
        CollectionUtils.nullSafeCollection(this.getTransactionListeners()).stream().filter(Objects::nonNull).forEach(transactionListener -> cache.getCacheTransactionManager().addListener(transactionListener));
        return cache;
    }

    @NonNull
    protected GemFireCache registerTransactionWriter(@NonNull GemFireCache cache) {
        Optional.ofNullable(this.getTransactionWriter()).ifPresent(transactionWriter -> cache.getCacheTransactionManager().setWriter(transactionWriter));
        return cache;
    }

    @Nullable
    public DataAccessException translateExceptionIfPossible(@Nullable RuntimeException exception) {
        DataAccessException wrapped;
        if (exception instanceof IllegalArgumentException && !((wrapped = GemfireCacheUtils.convertQueryExceptions(exception)) instanceof GemfireSystemException)) {
            return wrapped;
        }
        if (exception instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)exception);
        }
        if (exception.getCause() instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)exception.getCause());
        }
        if (exception.getCause() instanceof GemFireCheckedException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireCheckedException)exception.getCause());
        }
        return null;
    }

    public static interface PdxConfigurer<T> {
        public T getTarget();

        public PdxConfigurer<T> setDiskStoreName(String var1);

        public PdxConfigurer<T> setIgnoreUnreadFields(Boolean var1);

        public PdxConfigurer<T> setPersistent(Boolean var1);

        public PdxConfigurer<T> setReadSerialized(Boolean var1);

        public PdxConfigurer<T> setSerializer(PdxSerializer var1);
    }

    @FunctionalInterface
    public static interface CacheFactoryInitializer<T>
    extends Function<T, T> {
        @Override
        default public T apply(T t) {
            return this.initialize(t);
        }

        public T initialize(T var1);
    }
}

