/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class CollectionUtils
extends org.springframework.util.CollectionUtils {
    public static <E, T extends Collection<E>> T addAll(@NonNull T collection, @Nullable Iterable<E> iterable) {
        Assert.notNull(collection, (String)"Collection is required");
        StreamSupport.stream(CollectionUtils.nullSafeIterable(iterable).spliterator(), false).forEach(collection::add);
        return collection;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... elements) {
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return Collections.unmodifiableSet(set);
    }

    public static boolean containsAny(@Nullable Collection<?> collection, Object ... elements) {
        return Arrays.asList(ArrayUtils.nullSafeArray(elements, Object.class)).stream().anyMatch(element -> CollectionUtils.nullSafeCollection(collection).contains(element));
    }

    @NonNull
    public static <T> Iterable<T> emptyIterable() {
        return Collections::emptyIterator;
    }

    @NonNull
    public static <T> Iterable<T> iterable(@Nullable Enumeration<T> enumeration) {
        return () -> CollectionUtils.toIterator(CollectionUtils.nullSafeEnumeration(enumeration));
    }

    @NonNull
    public static <T> Iterable<T> iterable(@Nullable Iterator<T> iterator) {
        return () -> CollectionUtils.nullSafeIterator(iterator);
    }

    @NonNull
    public static <T> Collection<T> nullSafeCollection(@Nullable Collection<T> collection) {
        return collection != null ? collection : Collections.emptyList();
    }

    @NonNull
    public static <T> Enumeration<T> nullSafeEnumeration(@Nullable Enumeration<T> enumeration) {
        return enumeration != null ? enumeration : Collections.emptyEnumeration();
    }

    @NonNull
    public static <T> Iterable<T> nullSafeIterable(@Nullable Iterable<T> iterable) {
        return iterable != null ? iterable : CollectionUtils.emptyIterable();
    }

    @Nullable
    public static <E, T extends Iterable<E>> T nullSafeIterable(@Nullable T iterable, @Nullable T defaultIterable) {
        return (T)Optional.ofNullable(iterable).filter(it -> it.iterator().hasNext()).orElse(defaultIterable);
    }

    @NonNull
    public static <T> Iterator<T> nullSafeIterator(@Nullable Iterator<T> iterator) {
        return iterator != null ? iterator : Collections.emptyIterator();
    }

    @NonNull
    public static <T> List<T> nullSafeList(@Nullable List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    @NonNull
    public static <K, V> Map<K, V> nullSafeMap(@Nullable Map<K, V> map) {
        return map != null ? map : Collections.emptyMap();
    }

    @NonNull
    public static <T> Set<T> nullSafeSet(@Nullable Set<T> set) {
        return set != null ? set : Collections.emptySet();
    }

    public static boolean nullSafeIsEmpty(@Nullable Collection<?> collection) {
        return CollectionUtils.nullSafeCollection(collection).isEmpty();
    }

    public static boolean nullSafeIsEmpty(@Nullable Iterable<?> iterable) {
        return !CollectionUtils.nullSafeIterable(iterable).iterator().hasNext();
    }

    public static boolean nullSafeIsEmpty(@Nullable Map<?, ?> map) {
        return CollectionUtils.nullSafeMap(map).isEmpty();
    }

    public static int nullSafeSize(@Nullable Collection<?> collection) {
        return CollectionUtils.nullSafeCollection(collection).size();
    }

    public static long nullSafeSize(@Nullable Iterable iterable) {
        return StreamSupport.stream(CollectionUtils.nullSafeIterable(iterable).spliterator(), false).count();
    }

    public static int nullSafeSize(@Nullable Map<?, ?> map) {
        return CollectionUtils.nullSafeMap(map).size();
    }

    public static <T extends Comparable<T>> List<T> sort(@NonNull List<T> list) {
        Assert.notNull(list, (String)"List is required");
        Collections.sort(list);
        return list;
    }

    public static <T> List<T> subList(@NonNull List<T> source, int ... indices) {
        Assert.notNull(source, (String)"List is required");
        ArrayList<T> result = new ArrayList<T>(indices.length);
        for (int index : indices) {
            result.add(source.get(index));
        }
        return result;
    }

    @NonNull
    public static String toString(@Nullable Map<?, ?> map) {
        StringBuilder builder = new StringBuilder("{\n");
        AtomicInteger count = new AtomicInteger(0);
        CollectionUtils.newSortedMap(map).forEach((key, value) -> {
            builder.append(count.incrementAndGet() > 1 ? ",\n" : "");
            builder.append("\t");
            builder.append(key);
            builder.append(" = ");
            builder.append(value);
        });
        builder.append("\n}");
        return builder.toString();
    }

    @NonNull
    private static SortedMap<?, ?> newSortedMap(@Nullable Map<?, ?> map) {
        return new TreeMap(CollectionUtils.nullSafeMap(map));
    }
}

