/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedMember;
import org.springframework.data.gemfire.function.execution.AbstractFunctionExecution;

class OnDistributedMembersFunctionExecution
extends AbstractFunctionExecution {
    private final Set<DistributedMember> distributedMembers;

    public OnDistributedMembersFunctionExecution(Set<DistributedMember> distributedMembers) {
        this.distributedMembers = distributedMembers;
    }

    protected Set<DistributedMember> getDistributedMembers() {
        return this.distributedMembers != null ? Collections.unmodifiableSet(this.distributedMembers) : Collections.emptySet();
    }

    @Override
    protected Execution getExecution() {
        return FunctionService.onMembers(this.getDistributedMembers());
    }
}

