/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.internal.datasource.ConfigProperty;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.security.SecurityManager;
import org.springframework.data.gemfire.AbstractBasicCacheFactoryBean;
import org.springframework.data.gemfire.AbstractResolvableCacheFactoryBean;
import org.springframework.data.gemfire.GemFireProperties;
import org.springframework.data.gemfire.JndiDataSourceType;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CacheFactoryBean
extends AbstractResolvableCacheFactoryBean {
    private Boolean enableAutoReconnect;
    private Boolean useClusterConfiguration;
    private GatewayConflictResolver gatewayConflictResolver;
    private Integer lockLease;
    private Integer lockTimeout;
    private Integer messageSyncInterval;
    private Integer searchTimeout;
    private List<JndiDataSource> jndiDataSources;
    private final List<PeerCacheConfigurer> peerCacheConfigurers = new ArrayList<PeerCacheConfigurer>();
    private final PeerCacheConfigurer compositePeerCacheConfigurer = (beanName, bean) -> CollectionUtils.nullSafeList(this.peerCacheConfigurers).forEach(peerCacheConfigurer -> peerCacheConfigurer.configure(beanName, bean));
    private SecurityManager securityManager;

    @Override
    protected void applyCacheConfigurers() {
        PeerCacheConfigurer autoReconnectClusterConfigurationConfigurer = (beanName, cacheFactoryBean) -> {
            Properties gemfireProperties = this.resolveProperties();
            gemfireProperties.setProperty(GemFireProperties.DISABLE_AUTO_RECONNECT.getName(), String.valueOf(!Boolean.TRUE.equals(this.getEnableAutoReconnect())));
            gemfireProperties.setProperty(GemFireProperties.USE_CLUSTER_CONFIGURATION.getName(), String.valueOf(Boolean.TRUE.equals(this.getUseClusterConfiguration())));
        };
        this.peerCacheConfigurers.add(autoReconnectClusterConfigurationConfigurer);
        this.applyPeerCacheConfigurers(this.getCompositePeerCacheConfigurer());
    }

    protected void applyPeerCacheConfigurers(PeerCacheConfigurer ... peerCacheConfigurers) {
        this.applyPeerCacheConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(peerCacheConfigurers, PeerCacheConfigurer.class)));
    }

    protected void applyPeerCacheConfigurers(Iterable<PeerCacheConfigurer> peerCacheConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(peerCacheConfigurers).spliterator(), false).forEach(peerCacheConfigurer -> peerCacheConfigurer.configure(this.getBeanName(), this));
    }

    @Override
    protected <T extends GemFireCache> T doFetchCache() {
        return (T)CacheFactory.getAnyInstance();
    }

    @Override
    protected Class<? extends GemFireCache> doGetObjectType() {
        return Cache.class;
    }

    @Override
    @NonNull
    protected Object createFactory(@NonNull Properties gemfireProperties) {
        return new CacheFactory(gemfireProperties);
    }

    @Override
    @NonNull
    protected Object configureFactory(@NonNull Object factory) {
        return this.configureSecurity(this.configurePdx((CacheFactory)factory));
    }

    @NonNull
    protected CacheFactory configurePdx(@NonNull CacheFactory cacheFactory) {
        return this.configurePdx(CacheFactoryToPdxConfigurerAdapter.from(cacheFactory));
    }

    @NonNull
    protected CacheFactory configureSecurity(@NonNull CacheFactory cacheFactory) {
        SecurityManager securityManager = this.getSecurityManager();
        return securityManager != null ? cacheFactory.setSecurityManager(securityManager) : cacheFactory;
    }

    @Override
    @NonNull
    protected <T extends GemFireCache> T createCache(@NonNull Object factory) {
        return (T)((CacheFactory)factory).create();
    }

    @Override
    @NonNull
    protected <T extends GemFireCache> T postProcess(@NonNull T cache) {
        super.postProcess(cache);
        if (cache instanceof Cache) {
            Cache peerCache = (Cache)cache;
            Optional.ofNullable(this.getGatewayConflictResolver()).ifPresent(arg_0 -> ((Cache)peerCache).setGatewayConflictResolver(arg_0));
            Optional.ofNullable(this.getLockLease()).ifPresent(arg_0 -> ((Cache)peerCache).setLockLease(arg_0));
            Optional.ofNullable(this.getLockTimeout()).ifPresent(arg_0 -> ((Cache)peerCache).setLockTimeout(arg_0));
            Optional.ofNullable(this.getMessageSyncInterval()).ifPresent(arg_0 -> ((Cache)peerCache).setMessageSyncInterval(arg_0));
            Optional.ofNullable(this.getSearchTimeout()).ifPresent(arg_0 -> ((Cache)peerCache).setSearchTimeout(arg_0));
        }
        this.registerJndiDataSources(cache);
        return cache;
    }

    private GemFireCache registerJndiDataSources(GemFireCache cache) {
        CollectionUtils.nullSafeCollection(this.getJndiDataSources()).forEach(jndiDataSource -> {
            String type = jndiDataSource.getAttributes().get("type");
            JndiDataSourceType jndiDataSourceType = JndiDataSourceType.valueOfIgnoreCase(type);
            Assert.notNull((Object)((Object)jndiDataSourceType), (String)String.format("'jndi-binding' 'type' [%1$s] is invalid; 'type' must be one of %2$s", type, Arrays.toString((Object[])JndiDataSourceType.values())));
            jndiDataSource.getAttributes().put("type", jndiDataSourceType.getName());
            SpringUtils.safeRunOperation(() -> JNDIInvoker.mapDatasource(jndiDataSource.getAttributes(), jndiDataSource.getProps()));
        });
        return cache;
    }

    @NonNull
    public PeerCacheConfigurer getCompositePeerCacheConfigurer() {
        return this.compositePeerCacheConfigurer;
    }

    public void setEnableAutoReconnect(@Nullable Boolean enableAutoReconnect) {
        this.enableAutoReconnect = enableAutoReconnect;
    }

    @Nullable
    public Boolean getEnableAutoReconnect() {
        return this.enableAutoReconnect;
    }

    public void setGatewayConflictResolver(@Nullable GatewayConflictResolver gatewayConflictResolver) {
        this.gatewayConflictResolver = gatewayConflictResolver;
    }

    @Nullable
    public GatewayConflictResolver getGatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    public void setJndiDataSources(List<JndiDataSource> jndiDataSources) {
        this.jndiDataSources = jndiDataSources;
    }

    public List<JndiDataSource> getJndiDataSources() {
        return this.jndiDataSources;
    }

    public void setLockLease(@Nullable Integer lockLease) {
        this.lockLease = lockLease;
    }

    @Nullable
    public Integer getLockLease() {
        return this.lockLease;
    }

    public void setLockTimeout(@Nullable Integer lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    @Nullable
    public Integer getLockTimeout() {
        return this.lockTimeout;
    }

    public void setMessageSyncInterval(@Nullable Integer messageSyncInterval) {
        this.messageSyncInterval = messageSyncInterval;
    }

    @Nullable
    public Integer getMessageSyncInterval() {
        return this.messageSyncInterval;
    }

    public void setPeerCacheConfigurers(PeerCacheConfigurer ... peerCacheConfigurers) {
        this.setPeerCacheConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(peerCacheConfigurers, PeerCacheConfigurer.class)));
    }

    public void setPeerCacheConfigurers(List<PeerCacheConfigurer> peerCacheConfigurers) {
        Optional.ofNullable(peerCacheConfigurers).ifPresent(this.peerCacheConfigurers::addAll);
    }

    public void setSearchTimeout(@Nullable Integer searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    @Nullable
    public Integer getSearchTimeout() {
        return this.searchTimeout;
    }

    public void setSecurityManager(@Nullable SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    @Nullable
    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setUseClusterConfiguration(@Nullable Boolean useSharedConfiguration) {
        this.useClusterConfiguration = useSharedConfiguration;
    }

    @Nullable
    public Boolean getUseClusterConfiguration() {
        return this.useClusterConfiguration;
    }

    public static class JndiDataSource {
        private List<ConfigProperty> configProperties;
        private Map<String, String> attributes;

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public List<ConfigProperty> getProps() {
            return this.configProperties;
        }

        public void setProps(List<ConfigProperty> props) {
            this.configProperties = props;
        }
    }

    public static class CacheFactoryToPdxConfigurerAdapter
    implements AbstractBasicCacheFactoryBean.PdxConfigurer<CacheFactory> {
        private final CacheFactory cacheFactory;

        public static CacheFactoryToPdxConfigurerAdapter from(@NonNull CacheFactory cacheFactory) {
            return new CacheFactoryToPdxConfigurerAdapter(cacheFactory);
        }

        protected CacheFactoryToPdxConfigurerAdapter(@NonNull CacheFactory cacheFactory) {
            Assert.notNull((Object)cacheFactory, (String)"CacheFactory must not be null");
            this.cacheFactory = cacheFactory;
        }

        @Override
        @NonNull
        public CacheFactory getTarget() {
            return this.cacheFactory;
        }

        @Override
        @NonNull
        public AbstractBasicCacheFactoryBean.PdxConfigurer<CacheFactory> setDiskStoreName(String diskStoreName) {
            this.getTarget().setPdxDiskStore(diskStoreName);
            return this;
        }

        @Override
        @NonNull
        public AbstractBasicCacheFactoryBean.PdxConfigurer<CacheFactory> setIgnoreUnreadFields(Boolean ignoreUnreadFields) {
            this.getTarget().setPdxIgnoreUnreadFields(ignoreUnreadFields.booleanValue());
            return this;
        }

        @Override
        @NonNull
        public AbstractBasicCacheFactoryBean.PdxConfigurer<CacheFactory> setPersistent(Boolean persistent) {
            this.getTarget().setPdxPersistent(persistent.booleanValue());
            return this;
        }

        @Override
        @NonNull
        public AbstractBasicCacheFactoryBean.PdxConfigurer<CacheFactory> setReadSerialized(Boolean readSerialized) {
            this.getTarget().setPdxReadSerialized(readSerialized.booleanValue());
            return this;
        }

        @Override
        @NonNull
        public AbstractBasicCacheFactoryBean.PdxConfigurer<CacheFactory> setSerializer(PdxSerializer pdxSerializer) {
            this.getTarget().setPdxSerializer(pdxSerializer);
            return this;
        }
    }
}

