/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class AbstractRegionParser
extends AbstractSingleBeanDefinitionParser {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    AbstractRegionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return this.getRegionFactoryClass();
    }

    protected abstract Class<?> getRegionFactoryClass();

    protected String getParentName(Element element) {
        String regionTemplate = element.getAttribute("template");
        return StringUtils.hasText((String)regionTemplate) ? regionTemplate : super.getParentName(element);
    }

    protected boolean isRegionTemplate(Element element) {
        String localName = element.getLocalName();
        return localName != null && localName.endsWith("-template");
    }

    protected boolean isSubRegion(Element element) {
        String localName = element.getParentNode().getLocalName();
        return localName != null && localName.endsWith("region");
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        builder.setAbstract(this.isRegionTemplate(element));
        this.doParseRegion(element, parserContext, builder, this.isSubRegion(element));
    }

    protected abstract void doParseRegion(Element var1, ParserContext var2, BeanDefinitionBuilder var3, boolean var4);

    protected void doParseRegionConfiguration(Element element, ParserContext parserContext, BeanDefinitionBuilder regionBuilder, BeanDefinitionBuilder regionAttributesBuilder, boolean subRegion) {
        this.mergeRegionTemplateAttributes(element, parserContext, regionBuilder, regionAttributesBuilder);
        String resolvedCacheReference = ParsingUtils.resolveCacheReference(element.getAttribute("cache-ref"));
        if (!subRegion) {
            regionBuilder.addPropertyReference("cache", resolvedCacheReference);
            ParsingUtils.setPropertyValue(element, regionBuilder, "close");
            ParsingUtils.setPropertyValue(element, regionBuilder, "destroy");
        }
        ParsingUtils.setPropertyValue(element, regionBuilder, "name");
        ParsingUtils.setPropertyValue(element, regionBuilder, "data-policy");
        ParsingUtils.setPropertyValue(element, regionBuilder, "ignore-if-exists", "lookupEnabled");
        ParsingUtils.setPropertyValue(element, regionBuilder, "persistent");
        ParsingUtils.setPropertyValue(element, regionBuilder, "shortcut");
        if (StringUtils.hasText((String)element.getAttribute("disk-store-ref"))) {
            ParsingUtils.setPropertyValue(element, regionBuilder, "disk-store-ref", "diskStoreName");
            regionBuilder.addDependsOn(element.getAttribute("disk-store-ref"));
        }
        ParsingUtils.parseOptionalRegionAttributes(element, parserContext, regionAttributesBuilder);
        ParsingUtils.parseSubscription(element, parserContext, regionAttributesBuilder);
        ParsingUtils.parseStatistics(element, regionAttributesBuilder);
        ParsingUtils.parseMembershipAttributes(element, parserContext, regionAttributesBuilder);
        ParsingUtils.parseExpiration(element, parserContext, regionAttributesBuilder);
        ParsingUtils.parseEviction(element, parserContext, regionAttributesBuilder);
        ParsingUtils.parseCompressor(element, parserContext, regionAttributesBuilder);
        List subElements = DomUtils.getChildElements((Element)element);
        for (Element subElement : subElements) {
            if (subElement.getLocalName().equals("cache-listener")) {
                regionBuilder.addPropertyValue("cacheListeners", ParsingUtils.parseRefOrNestedBeanDeclaration(subElement, parserContext, regionBuilder));
                continue;
            }
            if (subElement.getLocalName().equals("cache-loader")) {
                regionBuilder.addPropertyValue("cacheLoader", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(subElement, parserContext, regionBuilder));
                continue;
            }
            if (!subElement.getLocalName().equals("cache-writer")) continue;
            regionBuilder.addPropertyValue("cacheWriter", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(subElement, parserContext, regionBuilder));
        }
        if (!subRegion) {
            this.parseSubRegions(element, parserContext, resolvedCacheReference);
        }
    }

    void mergeRegionTemplateAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder regionBuilder, BeanDefinitionBuilder regionAttributesBuilder) {
        String regionTemplateName = this.getParentName(element);
        if (StringUtils.hasText((String)regionTemplateName)) {
            if (parserContext.getRegistry().containsBeanDefinition(regionTemplateName)) {
                BeanDefinition templateRegion = parserContext.getRegistry().getBeanDefinition(regionTemplateName);
                BeanDefinition templateRegionAttributes = this.getRegionAttributesBeanDefinition(templateRegion);
                if (templateRegionAttributes != null) {
                    regionAttributesBuilder.getRawBeanDefinition().overrideFrom(templateRegionAttributes);
                }
            } else {
                parserContext.getReaderContext().error(String.format("The Region template [%1$s] must be defined before the Region [%2$s] referring to the template", regionTemplateName, this.resolveId(element, regionBuilder.getRawBeanDefinition(), parserContext)), (Object)element);
            }
        }
    }

    BeanDefinition getRegionAttributesBeanDefinition(BeanDefinition region) {
        Assert.notNull((Object)region, (String)"BeanDefinition must not be null");
        Object regionAttributes = null;
        if (region.getPropertyValues().contains("attributes")) {
            regionAttributes = Optional.ofNullable(region.getPropertyValues().getPropertyValue("attributes")).map(PropertyValue::getValue).orElse(null);
        }
        return regionAttributes instanceof BeanDefinition ? (BeanDefinition)regionAttributes : null;
    }

    protected void parseCollectionOfCustomSubElements(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String className, String subElementName, String propertyName) {
        List subElements = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{subElementName, subElementName + "-ref"});
        if (!CollectionUtils.isEmpty((Collection)subElements)) {
            ManagedArray array = new ManagedArray(className, subElements.size());
            for (Element subElement : subElements) {
                array.add(ParsingUtils.parseRefOrNestedCustomElement(subElement, parserContext, builder));
            }
            builder.addPropertyValue(propertyName, (Object)array);
        }
    }

    protected void parseSubRegions(Element element, ParserContext parserContext, String resolvedCacheRef) {
        HashMap<String, Element> allSubRegionElements = new HashMap<String, Element>();
        this.findSubRegionElements(element, this.getRegionNameFromElement(element), allSubRegionElements);
        if (!CollectionUtils.isEmpty(allSubRegionElements)) {
            for (Map.Entry entry : allSubRegionElements.entrySet()) {
                this.parseSubRegion((Element)entry.getValue(), parserContext, (String)entry.getKey(), resolvedCacheRef);
            }
        }
    }

    private void findSubRegionElements(Element parent, String parentPath, Map<String, Element> allSubRegionElements) {
        for (Element element : DomUtils.getChildElements((Element)parent)) {
            if (!element.getLocalName().endsWith("region")) continue;
            String subRegionName = this.getRegionNameFromElement(element);
            String subRegionPath = this.buildSubRegionPath(parentPath, subRegionName);
            allSubRegionElements.put(subRegionPath, element);
            this.findSubRegionElements(element, subRegionPath, allSubRegionElements);
        }
    }

    private String getRegionNameFromElement(Element element) {
        String name = element.getAttribute("name");
        return StringUtils.hasText((String)name) ? name : element.getAttribute("id");
    }

    private String buildSubRegionPath(String parentName, String regionName) {
        String regionPath = StringUtils.arrayToDelimitedString((Object[])new String[]{parentName, regionName}, (String)"/");
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        return regionPath;
    }

    private BeanDefinition parseSubRegion(Element element, ParserContext parserContext, String subRegionPath, String cacheRef) {
        String parentBeanName = this.getParentRegionPathFrom(subRegionPath);
        String regionName = this.getRegionNameFromElement(element);
        element.setAttribute("id", subRegionPath);
        element.setAttribute("name", subRegionPath);
        BeanDefinition beanDefinition = parserContext.getDelegate().parseCustomElement(element);
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        propertyValues.add("cache", (Object)new RuntimeBeanReference(cacheRef));
        propertyValues.add("parent", (Object)new RuntimeBeanReference(parentBeanName));
        propertyValues.add("regionName", (Object)regionName);
        return beanDefinition;
    }

    private String getParentRegionPathFrom(String regionPath) {
        int index = regionPath.lastIndexOf("/");
        String parentPath = regionPath.substring(0, index);
        if (parentPath.lastIndexOf("/") == 0) {
            parentPath = parentPath.substring(1);
        }
        return parentPath;
    }

    protected void validateDataPolicyShortcutAttributesMutualExclusion(Element element, ParserContext parserContext) {
        if (element.hasAttribute("data-policy") && element.hasAttribute("shortcut")) {
            String message = String.format("Only one of [data-policy, shortcut] may be specified with element [%s]", element.getTagName());
            parserContext.getReaderContext().error(message, (Object)element);
        }
    }
}

