/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public enum IndexType {
    FUNCTIONAL(org.apache.geode.cache.query.IndexType.FUNCTIONAL),
    HASH(org.apache.geode.cache.query.IndexType.HASH),
    PRIMARY_KEY(org.apache.geode.cache.query.IndexType.PRIMARY_KEY),
    KEY(org.apache.geode.cache.query.IndexType.PRIMARY_KEY);

    public static final IndexType DEFAULT;
    private final org.apache.geode.cache.query.IndexType gemfireIndexType;

    private IndexType(org.apache.geode.cache.query.IndexType gemfireIndexType) {
        Assert.notNull((Object)gemfireIndexType, (String)"The Apache Geode IndexType must not be null");
        this.gemfireIndexType = gemfireIndexType;
    }

    public static boolean isFunctional(@Nullable IndexType indexType) {
        return indexType != null && indexType.isFunctional();
    }

    public static boolean isHash(IndexType indexType) {
        return indexType != null && indexType.isHash();
    }

    public static boolean isKey(IndexType indexType) {
        return indexType != null && indexType.isKey();
    }

    public static IndexType valueOf(org.apache.geode.cache.query.IndexType gemfireIndexType) {
        for (IndexType indexType : IndexType.values()) {
            if (!indexType.getGemfireIndexType().equals((Object)gemfireIndexType)) continue;
            return indexType;
        }
        return null;
    }

    public static IndexType valueOfIgnoreCase(String value) {
        for (IndexType indexType : IndexType.values()) {
            if (!indexType.name().equalsIgnoreCase(value)) continue;
            return indexType;
        }
        return null;
    }

    @NonNull
    public org.apache.geode.cache.query.IndexType getGemfireIndexType() {
        return this.gemfireIndexType;
    }

    public boolean isFunctional() {
        return this.equals((Object)FUNCTIONAL);
    }

    public boolean isHash() {
        return this.equals((Object)HASH);
    }

    public boolean isKey() {
        return this.equals((Object)KEY) || this.equals((Object)PRIMARY_KEY);
    }

    static {
        DEFAULT = FUNCTIONAL;
    }
}

