/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import org.apache.geode.cache.Region;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.gemfire.support.AbstractCachingRegionResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanFactoryRegionResolver
extends AbstractCachingRegionResolver
implements BeanFactoryAware {
    private BeanFactory beanFactory;

    public BeanFactoryRegionResolver(BeanFactory beanFactory) {
        this.setBeanFactory(beanFactory);
    }

    public final void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    @NonNull
    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    @Nullable
    protected <K, V> Region<K, V> doResolve(@Nullable String regionName) {
        BeanFactory beanFactory = this.getBeanFactory();
        return StringUtils.hasText((String)regionName) && beanFactory.containsBean(regionName) ? (Region)beanFactory.getBean(regionName, Region.class) : null;
    }
}

