/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.Scope;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.PeerRegionFactoryBean;
import org.springframework.data.gemfire.RegionShortcutWrapper;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;

public class LocalRegionFactoryBean<K, V>
extends PeerRegionFactoryBean<K, V> {
    @Override
    public void setScope(Scope scope) {
        throw RuntimeExceptionFactory.newUnsupportedOperationException("Setting the Scope on Local Regions is not allowed", new Object[0]);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.setScope(Scope.LOCAL);
        super.afterPropertiesSet();
    }

    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, DataPolicy dataPolicy) {
        if (dataPolicy == null || DataPolicy.NORMAL.equals(dataPolicy)) {
            DataPolicy resolvedDataPolicy = this.isPersistent() ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.NORMAL;
            regionFactory.setDataPolicy(resolvedDataPolicy);
            this.setDataPolicy(resolvedDataPolicy);
        } else if (DataPolicy.PRELOADED.equals(dataPolicy)) {
            DataPolicy resolvedDataPolicy = this.isPersistent() ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.PRELOADED;
            regionFactory.setDataPolicy(resolvedDataPolicy);
            this.setDataPolicy(resolvedDataPolicy);
        } else if (DataPolicy.PERSISTENT_REPLICATE.equals(dataPolicy) && RegionShortcutWrapper.valueOf(this.getShortcut()).isPersistent()) {
            regionFactory.setDataPolicy(dataPolicy);
            this.setDataPolicy(dataPolicy);
        } else {
            throw RuntimeExceptionFactory.newIllegalArgumentException("Data Policy [%s] is not supported for Local Regions", dataPolicy);
        }
    }

    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        DataPolicy resolvedDataPolicy = null;
        if (dataPolicy != null) {
            resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy [%s] is invalid", dataPolicy));
        }
        this.resolveDataPolicy(regionFactory, persistent, resolvedDataPolicy);
    }
}

