/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.eviction;

import org.apache.geode.cache.EvictionAction;

public enum EvictionActionType {
    LOCAL_DESTROY(EvictionAction.LOCAL_DESTROY),
    NONE(EvictionAction.NONE),
    OVERFLOW_TO_DISK(EvictionAction.OVERFLOW_TO_DISK);

    public static final EvictionActionType DEFAULT;
    private final EvictionAction evictionAction;

    private EvictionActionType(EvictionAction evictionAction) {
        this.evictionAction = evictionAction;
    }

    public static EvictionAction getEvictionAction(EvictionActionType evictionActionType) {
        return evictionActionType != null ? evictionActionType.getEvictionAction() : null;
    }

    public static EvictionActionType valueOf(EvictionAction evictionAction) {
        for (EvictionActionType evictionActionType : EvictionActionType.values()) {
            if (!evictionActionType.getEvictionAction().equals(evictionAction)) continue;
            return evictionActionType;
        }
        return null;
    }

    public static EvictionActionType valueOfIgnoreCase(String name) {
        for (EvictionActionType evictionActionType : EvictionActionType.values()) {
            if (!evictionActionType.name().equalsIgnoreCase(name)) continue;
            return evictionActionType;
        }
        return null;
    }

    public EvictionAction getEvictionAction() {
        return this.evictionAction;
    }

    static {
        DEFAULT = EvictionActionType.valueOf(EvictionAction.DEFAULT_EVICTION_ACTION);
    }
}

