/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.QueryPostProcessor;
import org.springframework.data.gemfire.repository.support.GemfireRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.RepositoryDefinition;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GemfireRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private GemFireCache cache;
    private Iterable<Region<?, ?>> regions;
    private MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext;

    public GemfireRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Map regionBeans = applicationContext.getBeansOfType(Region.class);
        HashSet regions = new HashSet(Collections.unmodifiableSet(regionBeans.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet())));
        this.getCache().map(RegionService::rootRegions).ifPresent(regions::addAll);
        this.regions = regions;
    }

    protected Optional<ApplicationContext> getApplicationContext() {
        return Optional.ofNullable(this.applicationContext);
    }

    public void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    protected Optional<GemFireCache> getCache() {
        return Optional.ofNullable(this.cache);
    }

    @Autowired(required=false)
    public void setGemfireMappingContext(MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext) {
        this.setMappingContext(mappingContext);
        this.mappingContext = mappingContext;
    }

    protected MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> getGemfireMappingContext() {
        return this.mappingContext;
    }

    private MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> resolveGemfireMappingContext() {
        MappingContext<GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext = this.getGemfireMappingContext();
        Assert.state((mappingContext != null ? 1 : 0) != 0, (String)"GemfireMappingContext must not be null");
        return mappingContext;
    }

    protected Iterable<Region<?, ?>> getRegions() {
        return this.regions;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        GemfireRepositoryFactory repositoryFactory = new GemfireRepositoryFactory(this.getRegions(), this.getGemfireMappingContext());
        this.getApplicationContext().map(applicationContext -> new QueryPostProcessorRegistrationOnQueryCreationListener((ApplicationContext)applicationContext)).ifPresent(arg_0 -> ((GemfireRepositoryFactory)repositoryFactory).addQueryCreationListener(arg_0));
        return repositoryFactory;
    }

    public void afterPropertiesSet() {
        this.resolveGemfireMappingContext();
        super.afterPropertiesSet();
    }

    static class QueryPostProcessorMetadata {
        private static final Map<QueryPostProcessorKey, QueryPostProcessorMetadata> cache = new WeakHashMap<QueryPostProcessorKey, QueryPostProcessorMetadata>();
        private final Class<?> declaredRepositoryType;
        private final QueryPostProcessor<?, ?> queryPostProcessor;

        static QueryPostProcessorMetadata from(@NonNull QueryPostProcessor<?, ?> queryPostProcessor) {
            return cache.computeIfAbsent(QueryPostProcessorKey.of(queryPostProcessor), key -> new QueryPostProcessorMetadata(key.getQueryPostProcessor()));
        }

        QueryPostProcessorMetadata(@NonNull QueryPostProcessor<?, ?> queryPostProcessor) {
            Assert.notNull(queryPostProcessor, (String)"QueryPostProcessor must not be null");
            this.queryPostProcessor = queryPostProcessor;
            List typeArguments = ClassTypeInformation.from(queryPostProcessor.getClass()).getRequiredSuperTypeInformation(QueryPostProcessor.class).getTypeArguments();
            this.declaredRepositoryType = Optional.of(typeArguments).filter(list -> !list.isEmpty()).map(list -> (TypeInformation)list.get(0)).map(typeInfo -> typeInfo.getType()).orElse(Repository.class);
        }

        @NonNull
        Class<?> getDeclaredRepositoryType() {
            return this.declaredRepositoryType;
        }

        @NonNull
        QueryPostProcessor<?, String> getQueryPostProcessor() {
            return this.queryPostProcessor;
        }

        boolean isMatch(Class<?> repositoryInterface) {
            return repositoryInterface != null && (this.getDeclaredRepositoryType().isAssignableFrom(repositoryInterface) || repositoryInterface.isAnnotationPresent(RepositoryDefinition.class));
        }

        GemfireRepositoryQuery register(GemfireRepositoryQuery repositoryQuery) {
            repositoryQuery.register(this.getQueryPostProcessor());
            return repositoryQuery;
        }

        private static class QueryPostProcessorKey {
            private final QueryPostProcessor<?, ?> queryPostProcessor;

            public static QueryPostProcessorKey of(QueryPostProcessor<?, ?> queryPostProcessor) {
                return new QueryPostProcessorKey(queryPostProcessor);
            }

            public QueryPostProcessorKey(@NonNull QueryPostProcessor<?, ?> queryPostProcessor) {
                Assert.notNull(queryPostProcessor, (String)"QueryPostProcessor must not be null");
                this.queryPostProcessor = queryPostProcessor;
            }

            @NonNull
            protected QueryPostProcessor<?, ?> getQueryPostProcessor() {
                return this.queryPostProcessor;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof QueryPostProcessorKey)) {
                    return false;
                }
                QueryPostProcessorKey that = (QueryPostProcessorKey)obj;
                return this.getQueryPostProcessor().equals(that.getQueryPostProcessor());
            }

            public int hashCode() {
                int hashValue = 17;
                hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode(this.getQueryPostProcessor());
                return hashValue;
            }

            public String toString() {
                return String.format("{ queryPostProcessor: %s }", this.getQueryPostProcessor());
            }
        }
    }

    protected class QueryPostProcessorRegistrationOnQueryCreationListener
    implements QueryCreationListener<GemfireRepositoryQuery> {
        private Iterable<QueryPostProcessorMetadata> queryPostProcessorsMetadata;

        public QueryPostProcessorRegistrationOnQueryCreationListener(ApplicationContext applicationContext) {
            Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
            ArrayList queryPostProcessors = new ArrayList(applicationContext.getBeansOfType(QueryPostProcessor.class).values());
            queryPostProcessors.sort(OrderComparator.INSTANCE);
            this.queryPostProcessorsMetadata = queryPostProcessors.stream().map(QueryPostProcessorMetadata::from).collect(Collectors.toList());
        }

        protected Iterable<QueryPostProcessorMetadata> getQueryPostProcessorsMetadata() {
            return this.queryPostProcessorsMetadata;
        }

        public void onCreation(GemfireRepositoryQuery repositoryQuery) {
            Class repositoryInterface = GemfireRepositoryFactoryBean.this.getRepositoryInformation().getRepositoryInterface();
            StreamSupport.stream(this.getQueryPostProcessorsMetadata().spliterator(), false).filter(queryPostProcessorMetadata -> queryPostProcessorMetadata.isMatch(repositoryInterface)).forEach(queryPostProcessorMetadata -> queryPostProcessorMetadata.register(repositoryQuery));
        }
    }
}

