/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.shiro.util.Assert;
import org.springframework.data.gemfire.function.execution.AbstractFunctionExecution;
import org.springframework.util.CollectionUtils;

class OnRegionFunctionExecution
extends AbstractFunctionExecution {
    private final Region<?, ?> region;
    private volatile Set<?> keys;

    public OnRegionFunctionExecution(Region<?, ?> region) {
        Assert.notNull(region, (String)"Region must not be null");
        this.region = region;
    }

    public OnRegionFunctionExecution setKeys(Set<?> keys) {
        this.keys = keys;
        return this;
    }

    @Override
    protected Set<?> getKeys() {
        return this.keys;
    }

    protected Region<?, ?> getRegion() {
        return this.region;
    }

    @Override
    protected Execution getExecution() {
        Execution execution = FunctionService.onRegion(this.getRegion());
        Set<?> keys = this.getKeys();
        execution = CollectionUtils.isEmpty(keys) ? execution : execution.withFilter(keys);
        return execution;
    }
}

