/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.eviction;

import org.apache.geode.cache.EvictionAlgorithm;

public enum EvictionPolicyType {
    ENTRY_COUNT(EvictionAlgorithm.LRU_ENTRY),
    HEAP_PERCENTAGE(EvictionAlgorithm.LRU_HEAP),
    MEMORY_SIZE(EvictionAlgorithm.LRU_MEMORY),
    NONE(EvictionAlgorithm.NONE);

    private final EvictionAlgorithm evictionAlgorithm;

    private EvictionPolicyType(EvictionAlgorithm evictionAlgorithm) {
        this.evictionAlgorithm = evictionAlgorithm;
    }

    public static EvictionAlgorithm getEvictionAlgorithm(EvictionPolicyType evictionPolicyType) {
        return evictionPolicyType != null ? evictionPolicyType.getEvictionAlgorithm() : null;
    }

    public static EvictionPolicyType valueOf(EvictionAlgorithm evictionAlgorithm) {
        for (EvictionPolicyType evictionPolicyType : EvictionPolicyType.values()) {
            if (!evictionPolicyType.getEvictionAlgorithm().equals(evictionAlgorithm)) continue;
            return evictionPolicyType;
        }
        return null;
    }

    public static EvictionPolicyType valueOfIgnoreCase(String name) {
        for (EvictionPolicyType evictionPolicyType : EvictionPolicyType.values()) {
            if (!evictionPolicyType.name().equalsIgnoreCase(name)) continue;
            return evictionPolicyType;
        }
        return null;
    }

    public EvictionAlgorithm getEvictionAlgorithm() {
        return this.evictionAlgorithm;
    }
}

