/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.Iterator;
import org.springframework.data.gemfire.repository.query.Predicate;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;

class Predicates
implements Predicate {
    private final Predicate current;

    private Predicates(Predicate predicate) {
        this.current = predicate;
    }

    private static Predicates create(Predicate predicate) {
        return new Predicates(predicate);
    }

    public static Predicates create(Part part, Iterator<Integer> indexes) {
        return Predicates.create(new AtomicPredicate(part, indexes));
    }

    public Predicates and(final Predicate predicate) {
        return Predicates.create(new Predicate(){

            @Override
            public String toString(String alias) {
                return String.format("%s AND %s", Predicates.this.current.toString(alias), predicate.toString(alias));
            }
        });
    }

    public Predicates or(final Predicate predicate) {
        return Predicates.create(new Predicate(){

            @Override
            public String toString(String alias) {
                return String.format("%s OR %s", Predicates.this.current.toString(alias), predicate.toString(alias));
            }
        });
    }

    @Override
    public String toString(String alias) {
        return this.current.toString(alias);
    }

    public static class AtomicPredicate
    implements Predicate {
        private final Iterator<Integer> indexes;
        private final Part part;

        public AtomicPredicate(Part part, Iterator<Integer> indexes) {
            Assert.notNull((Object)part, (String)"Query Predicate Part must not be null");
            Assert.notNull(indexes, (String)"Iterator of numeric, indexed query parameter placeholders must not be null");
            this.part = part;
            this.indexes = indexes;
        }

        @Override
        public String toString(String alias) {
            if (this.isIgnoreCase()) {
                return String.format("%s.equalsIgnoreCase($%d)", this.resolveProperty(alias), this.indexes.next());
            }
            Part.Type partType = this.part.getType();
            switch (partType) {
                case IS_NULL: 
                case IS_NOT_NULL: {
                    return String.format("%s %s NULL", this.resolveProperty(alias), this.resolveOperator(partType));
                }
                case FALSE: 
                case TRUE: {
                    return String.format("%s %s %s", this.resolveProperty(alias), this.resolveOperator(partType), Part.Type.TRUE.equals((Object)partType));
                }
            }
            return String.format("%s %s $%d", this.resolveProperty(alias), this.resolveOperator(partType), this.indexes.next());
        }

        boolean isIgnoreCase() {
            switch (this.part.shouldIgnoreCase()) {
                case ALWAYS: 
                case WHEN_POSSIBLE: {
                    return true;
                }
            }
            return false;
        }

        String resolveProperty(String alias) {
            return String.format("%1$s.%2$s", this.resolveAlias(alias), this.part.getProperty().toDotPath());
        }

        String resolveAlias(String alias) {
            return alias != null ? alias : "x";
        }

        String resolveOperator(Part.Type partType) {
            switch (partType) {
                case IS_NULL: 
                case FALSE: 
                case TRUE: 
                case SIMPLE_PROPERTY: {
                    return "=";
                }
                case IS_NOT_NULL: 
                case NEGATING_SIMPLE_PROPERTY: {
                    return "!=";
                }
                case GREATER_THAN: {
                    return ">";
                }
                case GREATER_THAN_EQUAL: {
                    return ">=";
                }
                case LESS_THAN: {
                    return "<";
                }
                case LESS_THAN_EQUAL: {
                    return "<=";
                }
                case IN: {
                    return "IN SET";
                }
                case NOT_IN: {
                    return "NOT IN SET";
                }
                case LIKE: 
                case STARTING_WITH: 
                case ENDING_WITH: 
                case CONTAINING: {
                    return "LIKE";
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported operator %s!", partType));
        }
    }
}

