/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableLocator;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class LocatorConfiguration
extends EmbeddedServiceConfigurationSupport {
    protected static final int DEFAULT_LOCATOR_PORT = 10334;
    protected static final String START_LOCATOR_GEMFIRE_PROPERTY_NAME = "start-locator";

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableLocator.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        return Optional.of(this.resolveProperty(this.locatorProperty("enabled"), Boolean.TRUE)).filter(Boolean.TRUE::equals).map(enabled -> {
            String host = this.resolveHost(this.resolveProperty(this.locatorProperty("host"), (String)annotationAttributes.get("host")));
            int port = this.resolvePort(this.resolveProperty(this.locatorProperty("port"), (Integer)annotationAttributes.get("port")), 10334);
            return PropertiesBuilder.create().setProperty(START_LOCATOR_GEMFIRE_PROPERTY_NAME, String.format("%s[%d]", host, port)).build();
        }).orElseGet(Properties::new);
    }
}

