/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.data.gemfire.wan.AsyncEventQueueFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class AsyncEventQueueParser
extends AbstractSingleBeanDefinitionParser {
    AsyncEventQueueParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return AsyncEventQueueFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element eventSubstitutionFilterElement;
        builder.setLazyInit(false);
        this.parseAsyncEventListener(element, parserContext, builder);
        this.parseCache(element, builder);
        this.parseDiskStore(element, builder);
        ParsingUtils.setPropertyValue(element, builder, "enable-batch-conflation", "batchConflationEnabled");
        ParsingUtils.setPropertyValue(element, builder, "batch-conflation-enabled");
        ParsingUtils.setPropertyValue(element, builder, "batch-size");
        ParsingUtils.setPropertyValue(element, builder, "batch-time-interval");
        ParsingUtils.setPropertyValue(element, builder, "disk-synchronous");
        ParsingUtils.setPropertyValue(element, builder, "dispatcher-threads");
        ParsingUtils.setPropertyValue(element, builder, "forward-expiration-destroy");
        ParsingUtils.setPropertyValue(element, builder, "maximum-queue-memory");
        ParsingUtils.setPropertyValue(element, builder, "order-policy");
        ParsingUtils.setPropertyValue(element, builder, "parallel");
        ParsingUtils.setPropertyValue(element, builder, "persistent");
        Element eventFilterElement = DomUtils.getChildElementByTagName((Element)element, (String)"event-filter");
        if (eventFilterElement != null) {
            builder.addPropertyValue("gatewayEventFilters", ParsingUtils.parseRefOrNestedBeanDeclaration(eventFilterElement, parserContext, builder));
        }
        if ((eventSubstitutionFilterElement = DomUtils.getChildElementByTagName((Element)element, (String)"event-substitution-filter")) != null) {
            builder.addPropertyValue("gatewayEventSubstitutionFilter", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(eventSubstitutionFilterElement, parserContext, builder));
        }
        ParsingUtils.setPropertyValue(element, builder, "name");
        if (!StringUtils.hasText((String)element.getAttribute("name")) && element.getParentNode().getNodeName().endsWith("region")) {
            Element region = (Element)element.getParentNode();
            String regionName = StringUtils.hasText((String)region.getAttribute("name")) ? region.getAttribute("name") : region.getAttribute("id");
            int index = 0;
            String name = regionName + ".asyncEventQueue#" + index;
            while (parserContext.getRegistry().isBeanNameInUse(name)) {
                name = regionName + ".asyncEventQueue#" + ++index;
            }
            builder.addPropertyValue("name", (Object)name);
        }
    }

    private void parseAsyncEventListener(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element asyncEventListenerElement = DomUtils.getChildElementByTagName((Element)element, (String)"async-event-listener");
        Object asyncEventListener = ParsingUtils.parseRefOrSingleNestedBeanDeclaration(asyncEventListenerElement, parserContext, builder);
        builder.addPropertyValue("asyncEventListener", asyncEventListener);
        if (asyncEventListener instanceof RuntimeBeanReference) {
            builder.addDependsOn(((RuntimeBeanReference)asyncEventListener).getBeanName());
        }
    }

    private void parseCache(Element element, BeanDefinitionBuilder builder) {
        String cacheRefAttribute = element.getAttribute("cache-ref");
        String cacheName = SpringUtils.defaultIfEmpty(cacheRefAttribute, "gemfireCache");
        builder.addConstructorArgReference(cacheName);
    }

    private void parseDiskStore(Element element, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "disk-store-ref");
        String diskStoreRef = element.getAttribute("disk-store-ref");
        if (StringUtils.hasText((String)diskStoreRef)) {
            builder.addDependsOn(diskStoreRef);
        }
    }
}

