/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.context.annotation.Import;
import org.springframework.data.gemfire.config.annotation.ExpirationConfiguration;
import org.springframework.data.gemfire.expiration.ExpirationActionType;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@Import(value={ExpirationConfiguration.class})
public @interface EnableExpiration {
    public ExpirationPolicy[] policies() default {};

    public static enum ExpirationType {
        IDLE_TIMEOUT("TTI"),
        TIME_TO_LIVE("TTL");

        private final String abbreviation;

        static ExpirationType valueOfAbbreviation(String abbreviation) {
            for (ExpirationType expirationType : ExpirationType.values()) {
                if (!expirationType.abbreviation().equalsIgnoreCase(abbreviation)) continue;
                return expirationType;
            }
            return null;
        }

        private ExpirationType(String abbreviation) {
            this.abbreviation = abbreviation;
        }

        protected String abbreviation() {
            return this.abbreviation;
        }

        public String toString() {
            return String.format("%1$s (%2$s)", this.name(), this.abbreviation());
        }
    }

    public static @interface ExpirationPolicy {
        public int timeout();

        public ExpirationActionType action();

        public String[] regionNames() default {};

        public ExpirationType[] types() default {ExpirationType.IDLE_TIMEOUT};
    }
}

