/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.DiskStoreFactoryBean;
import org.springframework.data.gemfire.config.annotation.DiskStoreConfigurer;
import org.springframework.data.gemfire.config.annotation.EnableDiskStore;
import org.springframework.data.gemfire.config.annotation.LazyResolvingComposableDiskStoreConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.StringUtils;

public class DiskStoreConfiguration
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    protected static final boolean DEFAULT_ALLOW_FORCE_COMPACTION = false;
    protected static final boolean DEFAULT_AUTO_COMPACT = true;
    protected static final float DEFAULT_DISK_USAGE_CRITICAL_PERCENTAGE = 99.0f;
    protected static final float DEFAULT_DISK_USAGE_WARNING_PERCENTAGE = 90.0f;
    protected static final int DEFAULT_COMPACTION_THRESHOLD = 50;
    protected static final int DEFAULT_QUEUE_SIZE = 0;
    protected static final int DEFAULT_WRITE_BUFFER_SIZE = 32768;
    protected static final long DEFAULT_MAX_OPLOG_SIZE = 1024L;
    protected static final long DEFAULT_TIME_INTERVAL = 1000L;
    @Autowired(required=false)
    private List<DiskStoreConfigurer> diskStoreConfigurers = Collections.emptyList();

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableDiskStore.class;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (importingClassMetadata.hasAnnotation(this.getAnnotationTypeName())) {
            AnnotationAttributes enableDiskStoreAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(this.getAnnotationTypeName()));
            this.registerDiskStoreBeanDefinition(enableDiskStoreAttributes, registry);
        }
    }

    protected void registerDiskStoreBeanDefinition(AnnotationAttributes enableDiskStoreAttributes, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder diskStoreFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(DiskStoreFactoryBean.class);
        String diskStoreName = enableDiskStoreAttributes.getString("name");
        diskStoreFactoryBeanBuilder.addPropertyValue("beanName", (Object)diskStoreName);
        diskStoreFactoryBeanBuilder.addPropertyReference("cache", "gemfireCache");
        diskStoreFactoryBeanBuilder.addPropertyValue("diskStoreConfigurers", this.resolveDiskStoreConfigurers());
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "allowForceCompaction", enableDiskStoreAttributes.getBoolean("allowForceCompaction"), false);
        Optional.ofNullable(this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "allow-force-compaction"), this.resolveProperty(this.diskStoreProperty("allow-force-compaction"), (Boolean)null))).ifPresent(allowForceCompaction -> diskStoreFactoryBeanBuilder.addPropertyValue("allowForceCompaction", allowForceCompaction));
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "autoCompact", enableDiskStoreAttributes.getBoolean("autoCompact"), true);
        Optional.ofNullable(this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "auto-compact"), this.resolveProperty(this.diskStoreProperty("auto-compact"), (Boolean)null))).ifPresent(autoCompact -> diskStoreFactoryBeanBuilder.addPropertyValue("autoCompact", autoCompact));
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "compactionThreshold", enableDiskStoreAttributes.getNumber("compactionThreshold"), 50);
        Optional.ofNullable(this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "compaction-threshold"), this.resolveProperty(this.diskStoreProperty("compaction-threshold"), (Integer)null))).ifPresent(compactionThreshold -> diskStoreFactoryBeanBuilder.addPropertyValue("compactionThreshold", compactionThreshold));
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "diskUsageCriticalPercentage", enableDiskStoreAttributes.getNumber("diskUsageCriticalPercentage"), Float.valueOf(99.0f));
        Optional.ofNullable(this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "disk-usage-critical-percentage"), this.resolveProperty(this.diskStoreProperty("disk-usage-critical-percentage"), (Float)null))).ifPresent(diskUsageCriticalPercentage -> diskStoreFactoryBeanBuilder.addPropertyValue("diskUsageCriticalPercentage", diskUsageCriticalPercentage));
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "diskUsageWarningPercentage", enableDiskStoreAttributes.getNumber("diskUsageWarningPercentage"), Float.valueOf(90.0f));
        Optional.ofNullable(this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "disk-usage-warning-percentage"), this.resolveProperty(this.diskStoreProperty("disk-usage-warning-percentage"), (Float)null))).ifPresent(diskUsageWarningPercentage -> diskStoreFactoryBeanBuilder.addPropertyValue("diskUsageWarningPercentage", diskUsageWarningPercentage));
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "maxOplogSize", enableDiskStoreAttributes.getNumber("maxOplogSize"), 1024L);
        Optional.ofNullable(this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "max-oplog-size"), this.resolveProperty(this.diskStoreProperty("max-oplog-size"), (Long)null))).ifPresent(maxOplogSize -> diskStoreFactoryBeanBuilder.addPropertyValue("maxOplogSize", maxOplogSize));
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "queueSize", enableDiskStoreAttributes.getNumber("queueSize"), 0);
        Optional.ofNullable(this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "queue-size"), this.resolveProperty(this.diskStoreProperty("queue-size"), (Integer)null))).ifPresent(queueSize -> diskStoreFactoryBeanBuilder.addPropertyValue("queueSize", queueSize));
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "timeInterval", enableDiskStoreAttributes.getNumber("timeInterval"), 1000L);
        Optional.ofNullable(this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "time-interval"), this.resolveProperty(this.diskStoreProperty("time-interval"), (Long)null))).ifPresent(timeInterval -> diskStoreFactoryBeanBuilder.addPropertyValue("timeInterval", timeInterval));
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "writeBufferSize", enableDiskStoreAttributes.getNumber("writeBufferSize"), 32768);
        Optional.ofNullable(this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "write-buffer-size"), this.resolveProperty(this.diskStoreProperty("write-buffer-size"), (Integer)null))).ifPresent(writeBufferSize -> diskStoreFactoryBeanBuilder.addPropertyValue("writeBufferSize", writeBufferSize));
        this.resolveDiskStoreDirectories(diskStoreName, enableDiskStoreAttributes, diskStoreFactoryBeanBuilder);
        registry.registerBeanDefinition(diskStoreName, (BeanDefinition)diskStoreFactoryBeanBuilder.getBeanDefinition());
    }

    private List<DiskStoreConfigurer> resolveDiskStoreConfigurers() {
        return Optional.ofNullable(this.diskStoreConfigurers).filter(diskStoreConfigurers -> !diskStoreConfigurers.isEmpty()).orElseGet(() -> Collections.singletonList(LazyResolvingComposableDiskStoreConfigurer.create(this.getBeanFactory())));
    }

    protected BeanDefinitionBuilder resolveDiskStoreDirectories(String diskStoreName, AnnotationAttributes enableDiskStoreAttributes, BeanDefinitionBuilder diskStoreFactoryBeanBuilder) {
        ManagedList diskStoreDirectoryBeans = new ManagedList();
        String diskStoreDirectoryLocation = this.resolveProperty(this.diskStoreProperty("directory.location"), String.class);
        String namedDiskStoreDirectoryLocation = this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "directory.location"), String.class);
        Integer diskStoreDirectorySize = this.resolveProperty(this.diskStoreProperty("directory.size"), Integer.class);
        Integer namedDiskStoreDirectorySize = this.resolveProperty(this.namedDiskStoreProperty(diskStoreName, "directory.size"), Integer.class);
        List<String> namedDiskStoreDirectoryLocationProperties = this.arrayOfPropertyNamesFor(this.namedDiskStoreProperty(diskStoreName, "directory"), "location");
        if (!namedDiskStoreDirectoryLocationProperties.isEmpty()) {
            AtomicInteger index = new AtomicInteger(0);
            namedDiskStoreDirectoryLocationProperties.forEach(property -> {
                String location = this.requireProperty((String)property, String.class);
                Integer maxSize = this.resolveProperty(this.asArrayProperty(this.namedDiskStoreProperty(diskStoreName, "directory"), index.getAndIncrement(), "size"), Integer.class);
                maxSize = this.resolveDiskStoreDirectorySize(maxSize, namedDiskStoreDirectorySize, diskStoreDirectorySize);
                diskStoreDirectoryBeans.add((Object)this.newDiskStoreDirectoryBean(location, maxSize));
            });
        } else if (Optional.ofNullable(namedDiskStoreDirectoryLocation).filter(StringUtils::hasText).isPresent()) {
            diskStoreDirectoryBeans.add((Object)this.newDiskStoreDirectoryBean(namedDiskStoreDirectoryLocation, this.resolveDiskStoreDirectorySize(namedDiskStoreDirectorySize, diskStoreDirectorySize)));
        } else {
            List<String> diskStoreDirectoryLocationProperties = this.arrayOfPropertyNamesFor(this.diskStoreProperty("directory"), "location");
            if (!diskStoreDirectoryLocationProperties.isEmpty()) {
                AtomicInteger index = new AtomicInteger(0);
                diskStoreDirectoryLocationProperties.forEach(property -> {
                    String location = this.requireProperty((String)property, String.class);
                    Integer maxSize = this.resolveProperty(this.asArrayProperty(this.diskStoreProperty("directory"), index.getAndIncrement(), "size"), Integer.class);
                    maxSize = this.resolveDiskStoreDirectorySize(namedDiskStoreDirectorySize, maxSize, diskStoreDirectorySize);
                    diskStoreDirectoryBeans.add((Object)this.newDiskStoreDirectoryBean(location, maxSize));
                });
            } else if (Optional.ofNullable(diskStoreDirectoryLocation).filter(StringUtils::hasText).isPresent()) {
                diskStoreDirectoryBeans.add((Object)this.newDiskStoreDirectoryBean(diskStoreDirectoryLocation, this.resolveDiskStoreDirectorySize(namedDiskStoreDirectorySize, diskStoreDirectorySize)));
            } else {
                diskStoreDirectoryBeans.addAll(this.parseDiskStoreDirectories(enableDiskStoreAttributes));
            }
        }
        Optional.of(diskStoreDirectoryBeans).filter(beans -> !beans.isEmpty()).ifPresent(beans -> diskStoreFactoryBeanBuilder.addPropertyValue("diskDirs", (Object)diskStoreDirectoryBeans));
        return diskStoreFactoryBeanBuilder;
    }

    private String resolveDiskStoreDirectoryLocation(String ... locations) {
        return Arrays.stream(ArrayUtils.nullSafeArray(locations, String.class)).filter(StringUtils::hasText).findFirst().orElse(".");
    }

    private Integer resolveDiskStoreDirectorySize(Integer ... sizes) {
        return Arrays.stream(ArrayUtils.nullSafeArray(sizes, Integer.class)).filter(Objects::nonNull).findFirst().orElse(Integer.MAX_VALUE);
    }

    protected ManagedList<BeanDefinition> parseDiskStoreDirectories(AnnotationAttributes enableDiskStoreAttributes) {
        AnnotationAttributes[] diskDirectories = enableDiskStoreAttributes.getAnnotationArray("diskDirectories");
        ManagedList diskDirectoryBeans = new ManagedList(diskDirectories.length);
        Arrays.stream(ArrayUtils.nullSafeArray(diskDirectories, AnnotationAttributes.class)).forEach(diskDirectoryAttributes -> diskDirectoryBeans.add((Object)this.newDiskStoreDirectoryBean(diskDirectoryAttributes.getString("location"), (Integer)diskDirectoryAttributes.getNumber("maxSize"))));
        return diskDirectoryBeans;
    }

    private BeanDefinition newDiskStoreDirectoryBean(String location, Integer maxSize) {
        BeanDefinitionBuilder diskDirectoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(DiskStoreFactoryBean.DiskDir.class);
        diskDirectoryBuilder.addConstructorArgValue((Object)location);
        diskDirectoryBuilder.addConstructorArgValue((Object)maxSize);
        return diskDirectoryBuilder.getBeanDefinition();
    }

    private <T> BeanDefinitionBuilder setPropertyValueIfNotDefault(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, T value, T defaultValue) {
        return value != null && !value.equals(defaultValue) ? beanDefinitionBuilder.addPropertyValue(propertyName, value) : beanDefinitionBuilder;
    }
}

