/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.config.annotation.BeanFactoryLocatorConfiguration;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AutoConfiguredAuthenticationInitializer;
import org.springframework.data.gemfire.config.support.RestTemplateConfigurer;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={BeanFactoryLocatorConfiguration.class})
@Conditional(value={AutoConfiguredAuthenticationCondition.class})
public class AutoConfiguredAuthenticationConfiguration {
    protected static final String AUTO_CONFIGURED_AUTH_INIT_STATIC_FACTORY_METHOD = AutoConfiguredAuthenticationInitializer.class.getName().concat(".newAuthenticationInitializer");
    protected static final String DEFAULT_USERNAME = "test";
    protected static final String DEFAULT_PASSWORD = "test";
    protected static final String HTTP_PROTOCOL = "HTTP";
    protected static final String SECURITY_CLIENT_AUTH_INIT = "security-client-auth-init";
    protected static final String SECURITY_PEER_AUTH_INIT = "security-peer-auth-init";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean(value={"GemFireSecurityAuthenticator"})
    public Authenticator authenticator(final Environment environment) {
        Authenticator authenticator = new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                String username = environment.getProperty("spring.data.gemfire.security.username", "test");
                String password = environment.getProperty("spring.data.gemfire.security.password", "test");
                return new PasswordAuthentication(username, password.toCharArray());
            }
        };
        Authenticator.setDefault(authenticator);
        return authenticator;
    }

    ClientHttpRequestInterceptor loggingAwareClientHttpRequestInterceptor() {
        return (request, body, execution) -> {
            this.logger.debug("HTTP Request URI [{}]", (Object)request.getURI());
            Optional.ofNullable(request.getHeaders()).ifPresent(httpHeaders -> CollectionUtils.nullSafeSet(httpHeaders.keySet()).forEach(httpHeaderName -> this.logger.debug("HTTP Request Header Name [{}] Value [{}]", httpHeaderName, (Object)httpHeaders.get(httpHeaderName))));
            ClientHttpResponse response = execution.execute(request, body);
            Optional.ofNullable(response).ifPresent(it -> {
                try {
                    this.logger.debug("HTTP Response Status Code [{}] Message [{}]", (Object)it.getRawStatusCode(), (Object)it.getStatusText());
                }
                catch (IOException cause) {
                    this.logger.debug("Error occurred getting HTTP Response Status Code and Message", (Throwable)cause);
                }
            });
            return response;
        };
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public RestTemplateConfigurer loggingAwareRestTemplateConfigurer() {
        return restTemplate -> restTemplate.getInterceptors().add(this.loggingAwareClientHttpRequestInterceptor());
    }

    ClientHttpRequestInterceptor securityAwareClientHttpRequestInterceptor() {
        return (request, body, execution) -> {
            char[] password;
            URI uri = request.getURI();
            PasswordAuthentication passwordAuthentication = Authenticator.requestPasswordAuthentication(uri.getHost(), null, uri.getPort(), HTTP_PROTOCOL, null, uri.getScheme());
            String username = passwordAuthentication.getUserName();
            if (this.isAuthenticationEnabled(username, password = passwordAuthentication.getPassword())) {
                HttpHeaders requestHeaders = request.getHeaders();
                requestHeaders.add("security-username", username);
                requestHeaders.add("security-password", String.valueOf(password));
            }
            return execution.execute(request, body);
        };
    }

    @Bean
    @Order(value=-2147483648)
    public RestTemplateConfigurer securityAwareRestTemplateConfigurer(Authenticator authenticator) {
        return restTemplate -> restTemplate.getInterceptors().add(this.securityAwareClientHttpRequestInterceptor());
    }

    private boolean isAuthenticationEnabled(String username, char[] password) {
        return StringUtils.hasText((String)username) && password != null && password.length > 0;
    }

    @Bean
    public ClientCacheConfigurer authenticationCredentialsSettingClientCacheConfigurer(Environment environment) {
        return (beanName, beanFactory) -> this.setAuthenticationCredentials(beanFactory.getProperties(), environment);
    }

    @Bean
    public PeerCacheConfigurer authenticationCredentialsSettingPeerCacheConfigurer(Environment environment) {
        return (beanName, beanFactory) -> this.setAuthenticationCredentials(beanFactory.getProperties(), environment);
    }

    private void setAuthenticationCredentials(Properties gemfireProperties, Environment environment) {
        Optional.ofNullable(gemfireProperties).filter(properties -> AutoConfiguredAuthenticationConfiguration.isMatch(environment)).ifPresent(properties -> {
            properties.setProperty(SECURITY_CLIENT_AUTH_INIT, AUTO_CONFIGURED_AUTH_INIT_STATIC_FACTORY_METHOD);
            properties.setProperty(SECURITY_PEER_AUTH_INIT, AUTO_CONFIGURED_AUTH_INIT_STATIC_FACTORY_METHOD);
        });
    }

    private static boolean isMatch(Environment environment) {
        return Optional.ofNullable(environment).map(env -> env.getProperty("spring.data.gemfire.security.username")).map(StringUtils::hasText).isPresent();
    }

    public static class AutoConfiguredAuthenticationCondition
    implements Condition {
        public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            return AutoConfiguredAuthenticationConfiguration.isMatch(conditionContext.getEnvironment());
        }
    }
}

