/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.search.lucene;

import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.util.Assert;

public class LuceneServiceFactoryBean
extends AbstractFactoryBeanSupport<LuceneService>
implements InitializingBean {
    private GemFireCache gemfireCache;
    private LuceneService luceneService;

    public void afterPropertiesSet() throws Exception {
        GemFireCache gemfireCache = this.getCache();
        Assert.state((gemfireCache != null ? 1 : 0) != 0, (String)"A reference to the GemFireCache was not properly configured");
        this.luceneService = this.resolveLuceneService(gemfireCache);
    }

    protected LuceneService resolveLuceneService(GemFireCache gemFireCache) {
        return LuceneServiceProvider.get((GemFireCache)this.gemfireCache);
    }

    public LuceneService getObject() throws Exception {
        return this.luceneService;
    }

    public Class<?> getObjectType() {
        return Optional.ofNullable(this.luceneService).map(Object::getClass).orElse(LuceneService.class);
    }

    public void setCache(GemFireCache gemfireCache) {
        this.gemfireCache = gemfireCache;
    }

    protected GemFireCache getCache() {
        return this.gemfireCache;
    }
}

