/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.security.ResourcePermission;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.gemfire.function.PojoFunctionWrapper;
import org.springframework.data.gemfire.function.annotation.GemfireFunction;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class GemfireFunctionUtils {
    private static final String DEFAULT_FUNCTION_ID = null;
    private static Log log = LogFactory.getLog(GemfireFunctionUtils.class);

    public static boolean isGemfireFunction(Method method) {
        return method != null && method.isAnnotationPresent(GemfireFunction.class);
    }

    public static boolean isMatchingGemfireFunction(Method method, String functionId) {
        return GemfireFunctionUtils.getGemfireFunctionId(method).filter(methodFunctionId -> ObjectUtils.nullSafeEquals((Object)methodFunctionId, (Object)functionId)).isPresent();
    }

    static Annotation getAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getAnnotation((AnnotatedElement)element, annotationType);
    }

    static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, Annotation annotation) {
        return AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((AnnotatedElement)element, (Annotation)annotation));
    }

    static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return element.isAnnotationPresent(annotationType) ? GemfireFunctionUtils.getAnnotationAttributes(element, GemfireFunctionUtils.getAnnotation(element, annotationType)) : null;
    }

    public static Optional<String> getGemfireFunctionId(Method method) {
        return Optional.ofNullable(method).filter(GemfireFunctionUtils::isGemfireFunction).map(it -> Optional.ofNullable(GemfireFunctionUtils.getAnnotationAttributes((AnnotatedElement)it, GemfireFunction.class)).filter(annotationAttributes -> annotationAttributes.containsKey((Object)"id")).map(annotationAttributes -> annotationAttributes.getString("id")).filter(StringUtils::hasText).orElseGet(() -> it.getName()));
    }

    private static Object constructInstance(Class<?> type, Object ... constructorArguments) {
        return org.springframework.data.util.ReflectionUtils.findConstructor(type, (Object[])constructorArguments).map(constructor -> BeanUtils.instantiateClass((Constructor)constructor, (Object[])constructorArguments)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("No suitable constructor was found for type [%s] having parameters [%s]", type.getName(), Arrays.stream(ArrayUtils.nullSafeArray(constructorArguments, Object.class)).map(ObjectUtils::nullSafeClassName).collect(Collectors.toList())));
    }

    private static String nullSafeName(Method method) {
        return Optional.ofNullable(method).map(it -> String.format("%s.%s", method.getDeclaringClass().getName(), method.getName())).orElse(null);
    }

    public static void registerFunctionForPojoMethod(Class<?> type, String functionId) {
        Assert.notNull(type, () -> String.format("Class type of POJO containing %s(s) is required", GemfireFunction.class.getName()));
        ReflectionUtils.doWithMethods(type, method -> GemfireFunctionUtils.registerFunctionForPojoMethod(GemfireFunctionUtils.constructInstance(type, new Object[0]), method, GemfireFunctionUtils.getAnnotationAttributes((AnnotatedElement)method, GemfireFunction.class), true), method -> GemfireFunctionUtils.isMatchingGemfireFunction(method, functionId));
    }

    public static void registerFunctionForPojoMethod(Object target, String functionId) {
        Assert.notNull((Object)target, (String)"Target object is required");
        ReflectionUtils.doWithMethods(target.getClass(), method -> GemfireFunctionUtils.registerFunctionForPojoMethod(target, method, GemfireFunctionUtils.getAnnotationAttributes((AnnotatedElement)method, GemfireFunction.class), true), method -> GemfireFunctionUtils.isMatchingGemfireFunction(method, functionId));
    }

    public static void registerFunctionForPojoMethod(Object target, Method method, boolean overwrite) {
        Assert.notNull((Object)target, (String)"Target object is required");
        Assert.isTrue((boolean)GemfireFunctionUtils.isGemfireFunction(method), () -> String.format("Method [%s] must be a %s", GemfireFunctionUtils.nullSafeName(method), GemfireFunction.class.getName()));
        GemfireFunctionUtils.registerFunctionForPojoMethod(target, method, GemfireFunctionUtils.getAnnotationAttributes((AnnotatedElement)method, GemfireFunction.class), overwrite);
    }

    public static void registerFunctionForPojoMethod(Object target, Method method, AnnotationAttributes gemfireFunctionAttributes, boolean overwrite) {
        PojoFunctionWrapper function = new PojoFunctionWrapper(target, method, GemfireFunctionUtils.resolveFunctionId(gemfireFunctionAttributes));
        GemfireFunctionUtils.configureBatchSize(target, method, gemfireFunctionAttributes, function);
        GemfireFunctionUtils.configureHighAvailability(gemfireFunctionAttributes, function);
        GemfireFunctionUtils.configureHasResult(gemfireFunctionAttributes, function);
        GemfireFunctionUtils.configureOptimizeForWrite(gemfireFunctionAttributes, function);
        GemfireFunctionUtils.configureRequiredPermissions(gemfireFunctionAttributes, function);
        GemfireFunctionUtils.doFunctionRegistration(function, overwrite);
    }

    static String resolveFunctionId(AnnotationAttributes gemfireFunctionAttributes) {
        return gemfireFunctionAttributes.containsKey((Object)"id") ? gemfireFunctionAttributes.getString("id") : DEFAULT_FUNCTION_ID;
    }

    static void configureBatchSize(Object target, Method method, AnnotationAttributes gemfireFunctionAttributes, PojoFunctionWrapper function) {
        if (gemfireFunctionAttributes.containsKey((Object)"batchSize")) {
            int batchSize = (Integer)gemfireFunctionAttributes.getNumber("batchSize");
            Assert.isTrue((batchSize >= 0 ? 1 : 0) != 0, (String)String.format("%1$s.batchSize [%2$d] specified on [%3$s.%4$s] must be a non-negative value", GemfireFunction.class.getSimpleName(), batchSize, target.getClass().getName(), method.getName()));
            function.setBatchSize(batchSize);
        }
    }

    static void configureHighAvailability(AnnotationAttributes gemfireFunctionAttributes, PojoFunctionWrapper function) {
        if (gemfireFunctionAttributes.containsKey((Object)"HA")) {
            function.setHA(gemfireFunctionAttributes.getBoolean("HA"));
        }
    }

    static void configureHasResult(AnnotationAttributes gemfireFunctionAttributes, PojoFunctionWrapper function) {
        if (gemfireFunctionAttributes.containsKey((Object)"hasResult") && Boolean.TRUE.equals(gemfireFunctionAttributes.getBoolean("hasResult"))) {
            function.setHasResult(true);
        }
    }

    static void configureOptimizeForWrite(AnnotationAttributes gemfireFunctionAttributes, PojoFunctionWrapper function) {
        if (gemfireFunctionAttributes.containsKey((Object)"optimizeForWrite")) {
            function.setOptimizeForWrite(gemfireFunctionAttributes.getBoolean("optimizeForWrite"));
        }
    }

    static void configureRequiredPermissions(AnnotationAttributes gemfireFunctionAttributes, PojoFunctionWrapper function) {
        String[] requiredPermissionStrings = ArrayUtils.nullSafeArray(gemfireFunctionAttributes.containsKey((Object)"requiredPermissions") ? gemfireFunctionAttributes.getStringArray("requiredPermissions") : null, String.class);
        Stream<String> requiredPermissionsStream = Arrays.stream(requiredPermissionStrings);
        Optional.of(requiredPermissionsStream.filter(StringUtils::hasText).map(GemfireFunctionUtils::parseResourcePermission).collect(Collectors.toList())).filter(requiredPermissions -> !requiredPermissions.isEmpty()).ifPresent(function::setRequiredPermissions);
    }

    static ResourcePermission parseResourcePermission(String resourcePermissionString) {
        Assert.hasText((String)resourcePermissionString, (String)String.format("ResourcePermission [%s] is required", resourcePermissionString));
        ResourcePermission.Resource resource = ResourcePermission.Resource.DATA;
        ResourcePermission.Operation operation = ResourcePermission.Operation.WRITE;
        String key = null;
        String target = null;
        String[] resourcePermissionStringComponents = resourcePermissionString.split(":");
        if (resourcePermissionStringComponents.length > 0) {
            resource = GemfireFunctionUtils.parseEnum(resourcePermissionStringComponents[0], ResourcePermission.Resource.class, (Enum[])ResourcePermission.Resource.values());
        }
        if (resourcePermissionStringComponents.length > 1) {
            operation = GemfireFunctionUtils.parseEnum(resourcePermissionStringComponents[1], ResourcePermission.Operation.class, (Enum[])ResourcePermission.Operation.values());
        }
        if (resourcePermissionStringComponents.length > 2) {
            target = GemfireFunctionUtils.nullSafeTrim(resourcePermissionStringComponents[2]);
        }
        if (resourcePermissionStringComponents.length > 3) {
            key = GemfireFunctionUtils.nullSafeTrim(resourcePermissionStringComponents[3]);
        }
        return new ResourcePermission(resource, operation, target, key);
    }

    private static String nullSafeToUpperCase(String value) {
        return StringUtils.hasText((String)value) ? value.trim().toUpperCase() : "null";
    }

    private static String nullSafeTrim(String value) {
        return value != null ? value.trim() : null;
    }

    private static <T extends Enum<T>> T parseEnum(String name, Class<T> enumType, Enum[] enumeratedValues) {
        name = GemfireFunctionUtils.nullSafeToUpperCase(name);
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException cause) {
            throw RuntimeExceptionFactory.newIllegalArgumentException(cause, "[%1$s] is not a valid [%2$s] type; must be 1 of %3$s", name, enumType.getName(), Arrays.toString(enumeratedValues));
        }
    }

    static void doFunctionRegistration(PojoFunctionWrapper function, boolean overwrite) {
        if (FunctionService.isRegistered((String)function.getId()) && overwrite) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Overwrite enabled; Unregistering Function [%s]", function.getId()));
            }
            FunctionService.unregisterFunction((String)function.getId());
        }
        if (FunctionService.isRegistered((String)function.getId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Function [%s] is already registered", function.getId()));
            }
        } else {
            FunctionService.registerFunction((Function)function);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Registered Function [%s]", function.getId()));
            }
        }
    }

    public static int getAnnotationParameterPosition(Method method, Class<?> targetAnnotationType, Class<?>[] requiredTypes) {
        int position = -1;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length > 0) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            List<Class<?>> requiredTypesList = Arrays.asList(requiredTypes);
            for (int index = 0; index < parameterAnnotations.length; ++index) {
                Annotation[] annotations = parameterAnnotations[index];
                if (annotations.length <= 0) continue;
                for (Annotation annotation : annotations) {
                    if (!annotation.annotationType().equals(targetAnnotationType)) continue;
                    Assert.state((position < 0 ? 1 : 0) != 0, (String)String.format("Method %s signature cannot contain more than one parameter annotated with type %s", method.getName(), targetAnnotationType.getName()));
                    boolean isRequiredType = false;
                    for (Class<?> requiredType : requiredTypesList) {
                        if (!requiredType.isAssignableFrom(parameterTypes[index])) continue;
                        isRequiredType = true;
                        break;
                    }
                    Assert.isTrue((boolean)isRequiredType, (String)String.format("Parameter of type %s annotated with %s must be assignable from one of type %s in method %s", parameterTypes[index], targetAnnotationType.getName(), StringUtils.arrayToCommaDelimitedString((Object[])requiredTypes), method.getName()));
                    position = index;
                }
            }
        }
        return position;
    }
}

