/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Optional;
import java.util.Properties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.config.annotation.BeanFactoryLocatorConfiguration;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AutoConfiguredAuthenticationInitializer;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={BeanFactoryLocatorConfiguration.class})
@Conditional(value={AutoConfiguredAuthenticationCondition.class})
public class AutoConfiguredAuthenticationConfiguration {
    protected static final String AUTO_CONFIGURED_AUTH_INIT_STATIC_FACTORY_METHOD = AutoConfiguredAuthenticationInitializer.class.getName().concat(".newAuthenticationInitializer");
    protected static final String SECURITY_CLIENT_AUTH_INIT = "security-client-auth-init";
    protected static final String SECURITY_PEER_AUTH_INIT = "security-peer-auth-init";

    @Bean
    public ClientCacheConfigurer authenticationCredentialsSettingClientCacheConfigurer(Environment environment) {
        return (beanName, beanFactory) -> this.setAuthenticationCredentials(beanFactory.getProperties(), environment);
    }

    @Bean
    public PeerCacheConfigurer authenticationCredentialsSettingPeerCacheConfigurer(Environment environment) {
        return (beanName, beanFactory) -> this.setAuthenticationCredentials(beanFactory.getProperties(), environment);
    }

    private void setAuthenticationCredentials(Properties gemfireProperties, Environment environment) {
        Optional.ofNullable(gemfireProperties).filter(properties -> AutoConfiguredAuthenticationConfiguration.isMatch(environment)).ifPresent(properties -> {
            properties.setProperty(SECURITY_CLIENT_AUTH_INIT, AUTO_CONFIGURED_AUTH_INIT_STATIC_FACTORY_METHOD);
            properties.setProperty(SECURITY_PEER_AUTH_INIT, AUTO_CONFIGURED_AUTH_INIT_STATIC_FACTORY_METHOD);
        });
    }

    private static boolean isMatch(Environment environment) {
        return Optional.ofNullable(environment).map(env -> env.getProperty("spring.data.gemfire.security.username")).map(StringUtils::hasText).isPresent();
    }

    public static class AutoConfiguredAuthenticationCondition
    implements Condition {
        public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            return AutoConfiguredAuthenticationConfiguration.isMatch(conditionContext.getEnvironment());
        }
    }
}

