/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnablePool;
import org.springframework.data.gemfire.config.annotation.PoolConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public class AddPoolConfiguration
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    @Autowired(required=false)
    private List<PoolConfigurer> poolConfigurers = Collections.emptyList();

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (importingClassMetadata.hasAnnotation(EnablePool.class.getName())) {
            Map enablePoolAttributes = importingClassMetadata.getAnnotationAttributes(EnablePool.class.getName());
            this.registerPoolFactoryBeanDefinition(enablePoolAttributes, registry);
        }
    }

    protected void registerPoolFactoryBeanDefinition(Map<String, Object> enablePoolAttributes, BeanDefinitionRegistry registry) {
        String poolName = this.getAndValidatePoolName(enablePoolAttributes);
        BeanDefinitionBuilder poolFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(PoolFactoryBean.class);
        poolFactoryBean.addPropertyValue("freeConnectionTimeout", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "free-connection-timeout"), this.resolveProperty(this.poolProperty("free-connection-timeout"), (Integer)enablePoolAttributes.get("freeConnectionTimeout"))));
        poolFactoryBean.addPropertyValue("idleTimeout", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "idle-timeout"), this.resolveProperty(this.poolProperty("idle-timeout"), (Long)enablePoolAttributes.get("idleTimeout"))));
        poolFactoryBean.addPropertyValue("loadConditioningInterval", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "load-conditioning-interval"), this.resolveProperty(this.poolProperty("load-conditioning-interval"), (Integer)enablePoolAttributes.get("loadConditioningInterval"))));
        poolFactoryBean.addPropertyValue("maxConnections", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "max-connections"), this.resolveProperty(this.poolProperty("max-connections"), (Integer)enablePoolAttributes.get("maxConnections"))));
        poolFactoryBean.addPropertyValue("minConnections", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "min-connections"), this.resolveProperty(this.poolProperty("min-connections"), (Integer)enablePoolAttributes.get("minConnections"))));
        poolFactoryBean.addPropertyValue("multiUserAuthentication", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "multi-user-authentication"), this.resolveProperty(this.poolProperty("multi-user-authentication"), (Boolean)enablePoolAttributes.get("multiUserAuthentication"))));
        poolFactoryBean.addPropertyValue("pingInterval", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "ping-interval"), this.resolveProperty(this.poolProperty("ping-interval"), (Long)enablePoolAttributes.get("pingInterval"))));
        poolFactoryBean.addPropertyValue("poolConfigurers", this.resolvePoolConfigurers());
        poolFactoryBean.addPropertyValue("prSingleHopEnabled", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "pr-single-hop-enabled"), this.resolveProperty(this.poolProperty("pr-single-hop-enabled"), (Boolean)enablePoolAttributes.get("prSingleHopEnabled"))));
        poolFactoryBean.addPropertyValue("readTimeout", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "read-timeout"), this.resolveProperty(this.poolProperty("read-timeout"), (Integer)enablePoolAttributes.get("readTimeout"))));
        poolFactoryBean.addPropertyValue("retryAttempts", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "retry-attempts"), this.resolveProperty(this.poolProperty("retry-attempts"), (Integer)enablePoolAttributes.get("retryAttempts"))));
        poolFactoryBean.addPropertyValue("serverGroup", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "server-group"), this.resolveProperty(this.poolProperty("server-group"), (String)enablePoolAttributes.get("serverGroup"))));
        poolFactoryBean.addPropertyValue("socketBufferSize", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "socket-buffer-size"), this.resolveProperty(this.poolProperty("socket-buffer-size"), (Integer)enablePoolAttributes.get("socketBufferSize"))));
        poolFactoryBean.addPropertyValue("statisticInterval", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "statistic-interval"), this.resolveProperty(this.poolProperty("statistic-interval"), (Integer)enablePoolAttributes.get("statisticInterval"))));
        poolFactoryBean.addPropertyValue("subscriptionAckInterval", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "subscription-ack-interval"), this.resolveProperty(this.poolProperty("subscription-ack-interval"), (Integer)enablePoolAttributes.get("subscriptionAckInterval"))));
        poolFactoryBean.addPropertyValue("subscriptionEnabled", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "subscription-enabled"), this.resolveProperty(this.poolProperty("subscription-enabled"), (Boolean)enablePoolAttributes.get("subscriptionEnabled"))));
        poolFactoryBean.addPropertyValue("subscriptionMessageTrackingTimeout", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "subscription-message-tracking-timeout"), this.resolveProperty(this.poolProperty("subscription-message-tracking-timeout"), (Integer)enablePoolAttributes.get("subscriptionMessageTrackingTimeout"))));
        poolFactoryBean.addPropertyValue("subscriptionRedundancy", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "subscription-redundancy"), this.resolveProperty(this.poolProperty("subscription-redundancy"), (Integer)enablePoolAttributes.get("subscriptionRedundancy"))));
        poolFactoryBean.addPropertyValue("threadLocalConnections", (Object)this.resolveProperty(this.namedPoolProperty(poolName, "thread-local-connections"), this.resolveProperty(this.poolProperty("thread-local-connections"), (Boolean)enablePoolAttributes.get("threadLocalConnections"))));
        this.configurePoolConnections(poolName, enablePoolAttributes, poolFactoryBean);
        registry.registerBeanDefinition(poolName, (BeanDefinition)poolFactoryBean.getBeanDefinition());
    }

    private List<PoolConfigurer> resolvePoolConfigurers() {
        return Optional.ofNullable(this.poolConfigurers).filter(poolConfigurers -> !poolConfigurers.isEmpty()).orElseGet(() -> Optional.of(this.getBeanFactory()).filter(beanFactory -> beanFactory instanceof ListableBeanFactory).map(beanFactory -> {
            Map beansOfType = ((ListableBeanFactory)beanFactory).getBeansOfType(PoolConfigurer.class, true, true);
            return CollectionUtils.nullSafeMap(beansOfType).values().stream().collect(Collectors.toList());
        }).orElseGet(Collections::emptyList));
    }

    protected String getAndValidatePoolName(Map<String, Object> enablePoolAttributes) {
        return Optional.ofNullable((String)enablePoolAttributes.get("name")).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Pool name is required", new Object[0]));
    }

    protected BeanDefinitionBuilder configurePoolConnections(String poolName, Map<String, Object> enablePoolAttributes, BeanDefinitionBuilder poolFactoryBean) {
        this.configurePoolLocators(poolName, enablePoolAttributes, poolFactoryBean);
        this.configurePoolServers(poolName, enablePoolAttributes, poolFactoryBean);
        return poolFactoryBean;
    }

    protected BeanDefinitionBuilder configurePoolLocators(String poolName, Map<String, Object> enablePoolAttributes, BeanDefinitionBuilder poolFactoryBean) {
        String locatorsFromProperty = this.resolveProperty(this.namedPoolProperty(poolName, "locators"), this.resolveProperty(this.poolProperty("locators"), (String)null));
        ConnectionEndpointList locators = Optional.ofNullable(locatorsFromProperty).filter(StringUtils::hasText).map(it -> ConnectionEndpointList.parse(10334, it.split(","))).orElseGet(() -> this.parseConnectionEndpoints(enablePoolAttributes, "locators", "locatorsString", 10334));
        poolFactoryBean.addPropertyValue("locators", (Object)locators);
        return poolFactoryBean;
    }

    protected BeanDefinitionBuilder configurePoolServers(String poolName, Map<String, Object> enablePoolAttributes, BeanDefinitionBuilder poolFactoryBean) {
        String serversFromProperty = this.resolveProperty(this.namedPoolProperty(poolName, "servers"), this.resolveProperty("servers", (String)null));
        ConnectionEndpointList servers = Optional.ofNullable(serversFromProperty).filter(StringUtils::hasText).map(it -> ConnectionEndpointList.parse(40404, it.split(","))).orElseGet(() -> this.parseConnectionEndpoints(enablePoolAttributes, "servers", "serversString", 40404));
        poolFactoryBean.addPropertyValue("servers", (Object)servers);
        return poolFactoryBean;
    }

    protected ConnectionEndpointList parseConnectionEndpoints(Map<String, Object> enablePoolAttributes, String arrayAttributeName, String stringAttributeName, int defaultPort) {
        AnnotationAttributes[] connectionEndpointsMetaData = (AnnotationAttributes[])enablePoolAttributes.get(arrayAttributeName);
        ConnectionEndpointList connectionEndpoints = new ConnectionEndpointList();
        Arrays.stream(ArrayUtils.nullSafeArray(connectionEndpointsMetaData, AnnotationAttributes.class)).forEach(annotationAttributes -> connectionEndpoints.add(this.newConnectionEndpoint((String)annotationAttributes.get((Object)"host"), (Integer)annotationAttributes.get((Object)"port"))));
        Optional.ofNullable((String)enablePoolAttributes.get(stringAttributeName)).filter(StringUtils::hasText).ifPresent(hostsPorts -> connectionEndpoints.add(ConnectionEndpointList.parse(defaultPort, hostsPorts.split(","))));
        return connectionEndpoints;
    }

    protected ConnectionEndpoint newConnectionEndpoint(String host, Integer port) {
        return new ConnectionEndpoint(host, port);
    }

    protected Class getAnnotationType() {
        return EnablePool.class;
    }
}

