/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.EnableAutoRegionLookup;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.config.support.AutoRegionLookupBeanPostProcessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.util.StringUtils;

public class AutoRegionLookupConfiguration
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    private static final boolean DEFAULT_ENABLED = true;
    private static final AtomicBoolean AUTO_REGION_LOOKUP_BEAN_POST_PROCESSOR_REGISTERED = new AtomicBoolean(false);
    private Environment environment;
    private ExpressionParser spelParser = new SpelExpressionParser();
    private StandardEvaluationContext evaluationContext = new StandardEvaluationContext();

    protected Class getAnnotationType() {
        return EnableAutoRegionLookup.class;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)beanFactory;
            this.evaluationContext.setTypeLocator((TypeLocator)new StandardTypeLocator(configurableBeanFactory.getBeanClassLoader()));
            Optional.ofNullable(configurableBeanFactory.getConversionService()).ifPresent(conversionService -> this.evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService)));
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map enableAutoRegionLookupAttributes = importingClassMetadata.getAnnotationAttributes(EnableAutoRegionLookup.class.getName());
        Optional.ofNullable(this.resolveProperty(this.propertyName("enable-auto-region-lookup"), (Boolean)enableAutoRegionLookupAttributes.get("enabled"))).filter(Boolean.TRUE::equals).ifPresent(enabled -> this.registerAutoRegionLookupBeanPostProcessor(registry));
    }

    private boolean isEnabled(String enabled) {
        if (!Boolean.parseBoolean(enabled = StringUtils.trimWhitespace((String)enabled))) {
            try {
                return (Boolean)this.spelParser.parseExpression(enabled).getValue((EvaluationContext)this.evaluationContext, Boolean.TYPE);
            }
            catch (EvaluationException ignore) {
                return false;
            }
            catch (ParseException ignore) {
                return (Boolean)this.getEnvironment().getProperty(enabled, Boolean.TYPE, (Object)false);
            }
        }
        return true;
    }

    private void registerAutoRegionLookupBeanPostProcessor(BeanDefinitionRegistry registry) {
        if (AUTO_REGION_LOOKUP_BEAN_POST_PROCESSOR_REGISTERED.compareAndSet(false, true)) {
            AbstractBeanDefinition autoRegionLookupBeanPostProcessor = BeanDefinitionBuilder.rootBeanDefinition(AutoRegionLookupBeanPostProcessor.class).setRole(2).getBeanDefinition();
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)autoRegionLookupBeanPostProcessor, (BeanDefinitionRegistry)registry);
        }
    }
}

