/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.geode.cache.Region;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.repository.support.GemfireRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;

class GemfireRepositoryBean<T>
extends CdiRepositoryBean<T> {
    static final GemfireMappingContext DEFAULT_GEMFIRE_MAPPING_CONTEXT = new GemfireMappingContext();
    private final Bean<GemfireMappingContext> gemfireMappingContextBean;
    private final BeanManager beanManager;
    private final Set<Bean<Region>> regionBeans;

    GemfireRepositoryBean(BeanManager beanManager, Class<T> repositoryType, Set<Annotation> qualifiers, CustomRepositoryImplementationDetector detector, Bean<GemfireMappingContext> gemfireMappingContextBean, Set<Bean<Region>> regionBeans) {
        super(qualifiers, repositoryType, beanManager, Optional.ofNullable(detector));
        this.beanManager = beanManager;
        this.gemfireMappingContextBean = gemfireMappingContextBean;
        this.regionBeans = regionBeans;
    }

    protected <S> S getDependencyInstance(Bean<S> bean, Type type) {
        return (S)this.beanManager.getReference(bean, type, this.beanManager.createCreationalContext(bean));
    }

    protected <S> Type resolveType(Bean<S> bean, Class<S> targetType) {
        for (Type type : bean.getTypes()) {
            Type assignableType = type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type;
            if (!(assignableType instanceof Class) || !targetType.isAssignableFrom((Class)assignableType)) continue;
            return type;
        }
        throw new IllegalStateException(String.format("unable to resolve bean instance of type [%1$s] from bean definition [%2$s]", targetType, bean));
    }

    Iterable<Region<?, ?>> resolveGemfireRegions() {
        HashSet regions = new HashSet(this.regionBeans.size());
        for (Bean<Region> regionBean : this.regionBeans) {
            regions.add(this.getDependencyInstance(regionBean, this.resolveType(regionBean, Region.class)));
        }
        return regions;
    }

    GemfireMappingContext resolveGemfireMappingContext() {
        return this.gemfireMappingContextBean != null ? (GemfireMappingContext)((Object)this.getDependencyInstance(this.gemfireMappingContextBean, GemfireMappingContext.class)) : DEFAULT_GEMFIRE_MAPPING_CONTEXT;
    }

    GemfireRepositoryFactory newGemfireRepositoryFactory() {
        return new GemfireRepositoryFactory(this.resolveGemfireRegions(), (MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty>)this.resolveGemfireMappingContext());
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType, Optional<Object> customImplementation) {
        return (T)(customImplementation.isPresent() ? this.newGemfireRepositoryFactory().getRepository(repositoryType, customImplementation.get()) : this.newGemfireRepositoryFactory().getRepository(repositoryType));
    }
}

