/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.AbstractCacheConfiguration;
import org.springframework.data.gemfire.config.annotation.AdministrativeConfiguration;
import org.springframework.data.gemfire.config.annotation.PeerCacheApplication;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={AdministrativeConfiguration.class})
public class PeerCacheConfiguration
extends AbstractCacheConfiguration {
    protected static final boolean DEFAULT_ENABLE_AUTO_RECONNECT = false;
    protected static final boolean DEFAULT_USE_CLUSTER_CONFIGURATION = false;
    protected static final String DEFAULT_NAME = "SpringBasedPeerCacheApplication";
    private boolean enableAutoReconnect = false;
    private boolean useClusterConfiguration = false;
    private Integer lockLease;
    private Integer lockTimeout;
    private Integer messageSyncInterval;
    private Integer searchTimeout;
    @Autowired(required=false)
    private List<PeerCacheConfigurer> peerCacheConfigurers = Collections.emptyList();

    @Bean
    public CacheFactoryBean gemfireCache() {
        Object gemfireCache = this.constructCacheFactoryBean();
        ((CacheFactoryBean)gemfireCache).setEnableAutoReconnect(this.enableAutoReconnect());
        ((CacheFactoryBean)gemfireCache).setLockLease(this.lockLease());
        ((CacheFactoryBean)gemfireCache).setLockTimeout(this.lockTimeout());
        ((CacheFactoryBean)gemfireCache).setMessageSyncInterval(this.messageSyncInterval());
        ((CacheFactoryBean)gemfireCache).setPeerCacheConfigurers(this.resolvePeerCacheConfigurers());
        ((CacheFactoryBean)gemfireCache).setSearchTimeout(this.searchTimeout());
        ((CacheFactoryBean)gemfireCache).setUseBeanFactoryLocator(this.useBeanFactoryLocator());
        ((CacheFactoryBean)gemfireCache).setUseClusterConfiguration(this.useClusterConfiguration());
        return gemfireCache;
    }

    private List<PeerCacheConfigurer> resolvePeerCacheConfigurers() {
        return Optional.ofNullable(this.peerCacheConfigurers).filter(peerCacheConfigurers -> !peerCacheConfigurers.isEmpty()).orElseGet(() -> Optional.of(this.getBeanFactory()).filter(beanFactory -> beanFactory instanceof ListableBeanFactory).map(beanFactory -> {
            Map beansOfType = ((ListableBeanFactory)beanFactory).getBeansOfType(PeerCacheConfigurer.class, true, true);
            return CollectionUtils.nullSafeMap(beansOfType).values().stream().collect(Collectors.toList());
        }).orElseGet(Collections::emptyList));
    }

    @Override
    protected <T extends CacheFactoryBean> T newCacheFactoryBean() {
        return (T)new CacheFactoryBean();
    }

    @Override
    protected void configureCache(AnnotationMetadata importMetadata) {
        Map peerCacheApplicationAttributes;
        super.configureCache(importMetadata);
        if (this.isCacheServerOrPeerCacheApplication(importMetadata) && (peerCacheApplicationAttributes = importMetadata.getAnnotationAttributes(this.getAnnotationTypeName())) != null) {
            this.setEnableAutoReconnect(this.resolveProperty(this.cachePeerProperty("enable-auto-reconnect"), Boolean.TRUE.equals(peerCacheApplicationAttributes.get("enableAutoReconnect"))));
            this.setLockLease(this.resolveProperty(this.cachePeerProperty("lock-lease"), (Integer)peerCacheApplicationAttributes.get("lockLease")));
            this.setLockTimeout(this.resolveProperty(this.cachePeerProperty("lock-timeout"), (Integer)peerCacheApplicationAttributes.get("lockTimeout")));
            this.setMessageSyncInterval(this.resolveProperty(this.cachePeerProperty("message-sync-interval"), (Integer)peerCacheApplicationAttributes.get("messageSyncInterval")));
            this.setSearchTimeout(this.resolveProperty(this.cachePeerProperty("search-timeout"), (Integer)peerCacheApplicationAttributes.get("searchTimeout")));
            this.setUseClusterConfiguration(this.resolveProperty(this.cachePeerProperty("use-cluster-configuration"), Boolean.TRUE.equals(peerCacheApplicationAttributes.get("useClusterConfiguration"))));
            Optional.ofNullable((String)peerCacheApplicationAttributes.get("locators")).filter(AbstractAnnotationConfigSupport::hasValue).ifPresent(this::setLocators);
            Optional.ofNullable(this.resolveProperty(this.cachePeerProperty("locators"), (String)null)).filter(StringUtils::hasText).ifPresent(this::setLocators);
        }
    }

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return PeerCacheApplication.class;
    }

    void setEnableAutoReconnect(boolean enableAutoReconnect) {
        this.enableAutoReconnect = enableAutoReconnect;
    }

    protected boolean enableAutoReconnect() {
        return this.enableAutoReconnect;
    }

    void setLockLease(Integer lockLease) {
        this.lockLease = lockLease;
    }

    protected Integer lockLease() {
        return this.lockLease;
    }

    void setLockTimeout(Integer lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    protected Integer lockTimeout() {
        return this.lockTimeout;
    }

    void setMessageSyncInterval(Integer messageSyncInterval) {
        this.messageSyncInterval = messageSyncInterval;
    }

    protected Integer messageSyncInterval() {
        return this.messageSyncInterval;
    }

    void setSearchTimeout(Integer searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    protected Integer searchTimeout() {
        return this.searchTimeout;
    }

    void setUseClusterConfiguration(boolean useClusterConfiguration) {
        this.useClusterConfiguration = useClusterConfiguration;
    }

    protected boolean useClusterConfiguration() {
        return this.useClusterConfiguration;
    }

    @Override
    public String toString() {
        return DEFAULT_NAME;
    }
}

