/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import java.util.Collections;
import java.util.Map;
import org.apache.geode.pdx.PdxReader;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.PdxWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.GemfirePropertyValueProvider;
import org.springframework.data.gemfire.mapping.PdxReaderPropertyAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MappingPdxSerializer
implements PdxSerializer,
ApplicationContextAware {
    private final ConversionService conversionService;
    private EntityInstantiators entityInstantiators;
    private final GemfireMappingContext mappingContext;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Class<?>, PdxSerializer> customSerializers;
    private SpELContext context;

    public static MappingPdxSerializer create(GemfireMappingContext mappingContext, ConversionService conversionService) {
        mappingContext = mappingContext != null ? mappingContext : new GemfireMappingContext();
        conversionService = conversionService != null ? conversionService : new DefaultConversionService();
        return new MappingPdxSerializer(mappingContext, conversionService);
    }

    public MappingPdxSerializer() {
        this(new GemfireMappingContext(), (ConversionService)new DefaultConversionService());
    }

    public MappingPdxSerializer(GemfireMappingContext mappingContext, ConversionService conversionService) {
        Assert.notNull((Object)((Object)mappingContext), (String)"MappingContext is required");
        Assert.notNull((Object)conversionService, (String)"ConversionService is required");
        this.mappingContext = mappingContext;
        this.conversionService = conversionService;
        this.entityInstantiators = new EntityInstantiators();
        this.customSerializers = Collections.emptyMap();
        this.context = new SpELContext((PropertyAccessor)PdxReaderPropertyAccessor.INSTANCE);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = new SpELContext(this.context, (BeanFactory)applicationContext);
    }

    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setCustomSerializers(Map<Class<?>, PdxSerializer> customSerializers) {
        Assert.notNull(customSerializers, (String)"Custom PdxSerializers are required");
        this.customSerializers = customSerializers;
    }

    protected Map<Class<?>, PdxSerializer> getCustomSerializers() {
        return Collections.unmodifiableMap(this.customSerializers);
    }

    protected PdxSerializer getCustomSerializer(Class<?> type) {
        return this.getCustomSerializers().get(type);
    }

    public void setGemfireInstantiators(EntityInstantiators entityInstantiators) {
        Assert.notNull((Object)entityInstantiators, (String)"EntityInstantiators are required");
        this.entityInstantiators = entityInstantiators;
    }

    public void setGemfireInstantiators(Map<Class<?>, EntityInstantiator> gemfireInstantiators) {
        this.setGemfireInstantiators(new EntityInstantiators(gemfireInstantiators));
    }

    protected EntityInstantiators getGemfireInstantiators() {
        return this.entityInstantiators;
    }

    protected EntityInstantiator getInstantiatorFor(PersistentEntity entity) {
        return this.getGemfireInstantiators().getInstantiatorFor(entity);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected GemfireMappingContext getMappingContext() {
        return this.mappingContext;
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Object entity) {
        return this.getPersistentEntity(entity.getClass());
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Class<?> entityType) {
        return (GemfirePersistentEntity)this.getMappingContext().getPersistentEntity(entityType);
    }

    public Object fromData(Class<?> type, PdxReader reader) {
        GemfirePersistentEntity<?> entity = this.getPersistentEntity(type);
        Object instance = this.getInstantiatorFor((PersistentEntity)entity).createInstance(entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new GemfirePropertyValueProvider(reader), null));
        ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), this.getConversionService());
        entity.doWithProperties(arg_0 -> this.lambda$fromData$0(entity, instance, type, reader, (PersistentPropertyAccessor)propertyAccessor, arg_0));
        return propertyAccessor.getBean();
    }

    boolean isWritable(GemfirePersistentEntity<?> entity, GemfirePersistentProperty persistentProperty) {
        return !entity.isConstructorArgument((PersistentProperty)persistentProperty) && persistentProperty.isWritable() && !persistentProperty.isTransient();
    }

    public boolean toData(Object value, PdxWriter writer) {
        GemfirePersistentEntity<?> entity = this.getPersistentEntity(value);
        if (entity != null) {
            ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(value), this.getConversionService());
            entity.doWithProperties(arg_0 -> this.lambda$toData$1((PersistentPropertyAccessor)propertyAccessor, entity, writer, arg_0));
            GemfirePersistentProperty idProperty = (GemfirePersistentProperty)entity.getIdProperty();
            if (idProperty != null) {
                writer.markIdentityField(idProperty.getName());
            }
            return true;
        }
        return false;
    }

    boolean isReadable(GemfirePersistentProperty persistentProperty) {
        return !persistentProperty.isTransient();
    }

    private /* synthetic */ void lambda$toData$1(PersistentPropertyAccessor propertyAccessor, GemfirePersistentEntity entity, PdxWriter writer, GemfirePersistentProperty persistentProperty) {
        if (this.isReadable(persistentProperty)) {
            PdxSerializer customSerializer = this.getCustomSerializer(persistentProperty.getType());
            Object propertyValue = null;
            try {
                propertyValue = propertyAccessor.getProperty((PersistentProperty)persistentProperty);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("Serializing entity [%1$s] property [%2$s] value [%3$s] of type [%4$s] to PDX%5$s", entity.getType().getName(), persistentProperty.getName(), propertyValue, ObjectUtils.nullSafeClassName((Object)propertyValue), customSerializer != null ? String.format(" using custom PdxSerializer [%s]", customSerializer) : ""));
                }
                if (customSerializer != null) {
                    customSerializer.toData(propertyValue, writer);
                } else {
                    writer.writeField(persistentProperty.getName(), propertyValue, persistentProperty.getType());
                }
            }
            catch (Exception cause) {
                throw new MappingException(String.format("While serializing entity [%1$s] property [%2$s] value [%3$s] of type [%4$s] to PDX%5$s", entity.getType().getName(), persistentProperty.getName(), propertyValue, ObjectUtils.nullSafeClassName((Object)propertyValue), customSerializer != null ? String.format(" using custom PdxSerializer [%1$s].", customSerializer.getClass().getName()) : ""), (Throwable)cause);
            }
        }
    }

    private /* synthetic */ void lambda$fromData$0(GemfirePersistentEntity entity, Object instance, Class type, PdxReader reader, PersistentPropertyAccessor propertyAccessor, GemfirePersistentProperty persistentProperty) {
        if (this.isWritable(entity, persistentProperty)) {
            PdxSerializer customSerializer = this.getCustomSerializer(persistentProperty.getType());
            Object value = null;
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("Setting property [%1$s] for entity [%2$s] of type [%3$s] from PDX%4$s", persistentProperty.getName(), instance, type, customSerializer != null ? String.format(" using custom PdxSerializer [%1$s]", customSerializer) : ""));
                }
                Object object = value = customSerializer != null ? customSerializer.fromData(persistentProperty.getType(), reader) : reader.readField(persistentProperty.getName());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("... with value [%s]", value));
                }
                propertyAccessor.setProperty((PersistentProperty)persistentProperty, value);
            }
            catch (Exception cause) {
                throw new MappingException(String.format("While setting value [%1$s] of property [%2$s] for entity of type [%3$s] from PDX%4$s", value, persistentProperty.getName(), type, customSerializer != null ? String.format(" using custom PdxSerializer [%14s]", customSerializer) : ""), (Throwable)cause);
            }
        }
    }
}

