/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.gemfire.function.execution.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

abstract class FunctionExecutionMethodMetadata<T extends MethodMetadata> {
    protected final Map<Method, T> methodMetadata = new HashMap<Method, T>();
    private final boolean singletonInterface;

    public FunctionExecutionMethodMetadata(Class<?> serviceInterface) {
        this.singletonInterface = serviceInterface.getMethods().length == 1;
        ReflectionUtils.doWithMethods(serviceInterface, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Object mmd = FunctionExecutionMethodMetadata.this.newMetadataInstance(method);
                if (((MethodMetadata)mmd).getFunctionId() == null) {
                    ((MethodMetadata)mmd).setFunctionId(method.getName());
                }
                FunctionExecutionMethodMetadata.this.methodMetadata.put(method, mmd);
            }
        });
    }

    protected abstract T newMetadataInstance(Method var1);

    T getMethodMetadata(Method method) {
        return (T)((MethodMetadata)this.methodMetadata.get(method));
    }

    boolean isSingletonInterface() {
        return this.singletonInterface;
    }

    T getSingletonMethodMetada() {
        Assert.isTrue((boolean)this.isSingletonInterface(), (String)"this is not a singleton interface.");
        return (T)((MethodMetadata)this.methodMetadata.values().iterator().next());
    }
}

