/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.compression.Compressor;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.GenericRegionFactoryBean;
import org.springframework.data.gemfire.LocalRegionFactoryBean;
import org.springframework.data.gemfire.PartitionedRegionFactoryBean;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.RegionShortcutWrapper;
import org.springframework.data.gemfire.ReplicatedRegionFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.StringUtils;

public class CacheTypeAwareRegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V> {
    private GemFireCache gemfireCache;
    private Boolean close = false;
    private Boolean offHeap = false;
    private Class<K> keyConstraint;
    private Class<V> valueConstraint;
    private ClientRegionShortcut clientRegionShortcut = ClientRegionShortcut.PROXY;
    private Compressor compressor;
    private DataPolicy dataPolicy = DataPolicy.DEFAULT;
    private List<RegionConfigurer> regionConfigurers = Collections.emptyList();
    private RegionAttributes<K, V> regionAttributes;
    private RegionShortcut serverRegionShortcut;
    private Scope scope;
    private String diskStoreName;
    private String poolName;
    private String regionName;

    @Override
    public Region<K, V> createRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        return GemfireUtils.isClient(gemfireCache) ? this.newClientRegion(gemfireCache, regionName) : this.newServerRegion(gemfireCache, regionName);
    }

    protected Region<K, V> newClientRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        ClientRegionFactoryBean<K, V> clientRegionFactory = this.newClientRegionFactoryBean();
        clientRegionFactory.setAttributes(this.getRegionAttributes());
        clientRegionFactory.setBeanFactory(this.getBeanFactory());
        clientRegionFactory.setCache(gemfireCache);
        clientRegionFactory.setClose(this.isClose());
        clientRegionFactory.setCompressor(this.getCompressor());
        clientRegionFactory.setDiskStoreName(this.getDiskStoreName());
        clientRegionFactory.setKeyConstraint(this.getKeyConstraint());
        clientRegionFactory.setLookupEnabled(this.getLookupEnabled());
        clientRegionFactory.setRegionConfigurers(this.regionConfigurers);
        clientRegionFactory.setRegionName(regionName);
        clientRegionFactory.setShortcut(this.getClientRegionShortcut());
        clientRegionFactory.setValueConstraint(this.getValueConstraint());
        this.getPoolName().ifPresent(clientRegionFactory::setPoolName);
        clientRegionFactory.afterPropertiesSet();
        return clientRegionFactory.getObject();
    }

    protected <K, V> ClientRegionFactoryBean<K, V> newClientRegionFactoryBean() {
        return new ClientRegionFactoryBean();
    }

    protected Region<K, V> newServerRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        RegionFactoryBean<K, V> serverRegionFactory = this.newRegionFactoryBean();
        serverRegionFactory.setAttributes(this.getRegionAttributes());
        serverRegionFactory.setBeanFactory(this.getBeanFactory());
        serverRegionFactory.setCache(gemfireCache);
        serverRegionFactory.setClose(this.isClose());
        serverRegionFactory.setCompressor(this.getCompressor());
        serverRegionFactory.setDataPolicy(this.getDataPolicy());
        serverRegionFactory.setDiskStoreName(this.getDiskStoreName());
        serverRegionFactory.setKeyConstraint(this.getKeyConstraint());
        serverRegionFactory.setLookupEnabled(this.getLookupEnabled());
        serverRegionFactory.setOffHeap(this.getOffHeap());
        serverRegionFactory.setRegionConfigurers(this.regionConfigurers);
        serverRegionFactory.setRegionName(regionName);
        serverRegionFactory.setShortcut(this.getServerRegionShortcut());
        serverRegionFactory.setValueConstraint(this.getValueConstraint());
        serverRegionFactory.afterPropertiesSet();
        return serverRegionFactory.getObject();
    }

    protected RegionFactoryBean<K, V> newRegionFactoryBean() {
        RegionShortcutWrapper regionShortcutWrapper = RegionShortcutWrapper.valueOf(this.getServerRegionShortcut());
        DataPolicy resolvedDataPolicy = Optional.of(regionShortcutWrapper).map(RegionShortcutWrapper::getDataPolicy).orElseGet(this::getDataPolicy);
        if (regionShortcutWrapper.isLocal()) {
            return new LocalRegionFactoryBean();
        }
        if (resolvedDataPolicy.withPartitioning()) {
            return new PartitionedRegionFactoryBean();
        }
        if (resolvedDataPolicy.withReplication()) {
            ReplicatedRegionFactoryBean replicatedRegionFactoryBean = new ReplicatedRegionFactoryBean();
            replicatedRegionFactoryBean.setScope(this.getScope());
            return replicatedRegionFactoryBean;
        }
        return new GenericRegionFactoryBean();
    }

    public void setAttributes(RegionAttributes<K, V> regionAttributes) {
        this.regionAttributes = regionAttributes;
    }

    protected RegionAttributes<K, V> getRegionAttributes() {
        return this.regionAttributes;
    }

    public void setClientRegionShortcut(ClientRegionShortcut clientRegionShortcut) {
        this.clientRegionShortcut = clientRegionShortcut;
    }

    protected ClientRegionShortcut getClientRegionShortcut() {
        return Optional.ofNullable(this.clientRegionShortcut).orElse(ClientRegionShortcut.PROXY);
    }

    public void setClose(Boolean close) {
        this.close = close;
    }

    protected Boolean getClose() {
        return this.close;
    }

    protected boolean isClose() {
        return Boolean.TRUE.equals(this.getClose());
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    protected Compressor getCompressor() {
        return this.compressor;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    protected DataPolicy getDataPolicy() {
        return Optional.ofNullable(this.dataPolicy).orElse(DataPolicy.DEFAULT);
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    protected String getDiskStoreName() {
        return this.diskStoreName;
    }

    public void setKeyConstraint(Class<K> keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    protected Class<K> getKeyConstraint() {
        return this.keyConstraint;
    }

    public void setOffHeap(Boolean offHeap) {
        this.offHeap = offHeap;
    }

    protected Boolean getOffHeap() {
        return this.offHeap;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    protected Optional<String> getPoolName() {
        return Optional.ofNullable(this.poolName).filter(StringUtils::hasText);
    }

    protected String resolvePoolName() {
        return this.getPoolName().orElse(null);
    }

    public void setRegionConfigurers(RegionConfigurer ... regionConfigurers) {
        this.setRegionConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(regionConfigurers, RegionConfigurer.class)));
    }

    public void setRegionConfigurers(List<RegionConfigurer> regionConfigurers) {
        this.regionConfigurers = Optional.ofNullable(regionConfigurers).orElseGet(Collections::emptyList);
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    protected Scope getScope() {
        return this.scope;
    }

    public void setServerRegionShortcut(RegionShortcut shortcut) {
        this.serverRegionShortcut = shortcut;
    }

    protected RegionShortcut getServerRegionShortcut() {
        return this.serverRegionShortcut;
    }

    public void setValueConstraint(Class<V> valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    protected Class<V> getValueConstraint() {
        return this.valueConstraint;
    }
}

