/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.InterestRegistrationListener;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.shiro.util.Assert;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.CacheServerApplication;
import org.springframework.data.gemfire.config.annotation.CacheServerConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfiguration;
import org.springframework.data.gemfire.server.CacheServerFactoryBean;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicy;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
public class CacheServerConfiguration
extends PeerCacheConfiguration {
    protected static final boolean DEFAULT_AUTO_STARTUP = true;
    protected static final String DEFAULT_NAME = "SpringBasedCacheServerApplication";
    private boolean autoStartup = true;
    private Boolean tcpNoDelay;
    private Integer maxConnections;
    private Integer maxMessageCount;
    private Integer maxThreads;
    private Integer maxTimeBetweenPings;
    private Integer messageTimeToLive;
    private Integer port;
    private Integer socketBufferSize;
    private Integer subscriptionCapacity;
    @Autowired(required=false)
    private List<CacheServerConfigurer> cacheServerConfigurers = Collections.emptyList();
    private Long loadPollInterval;
    private ServerLoadProbe serverLoadProbe;
    private Set<InterestRegistrationListener> interestRegistrationListeners;
    private String bindAddress;
    private String hostnameForClients;
    private String subscriptionDiskStoreName;
    private SubscriptionEvictionPolicy subscriptionEvictionPolicy;

    @Bean
    public CacheServerFactoryBean gemfireCacheServer(GemFireCache gemfireCache) {
        Assert.isInstanceOf(Cache.class, (Object)gemfireCache, (String)"GemFireCache must be an instance of org.apache.geode.cache.Cache");
        CacheServerFactoryBean gemfireCacheServer = new CacheServerFactoryBean();
        gemfireCacheServer.setCache((Cache)gemfireCache);
        gemfireCacheServer.setCacheServerConfigurers(this.resolveCacheServerConfigurers());
        gemfireCacheServer.setAutoStartup(this.isAutoStartup());
        gemfireCacheServer.setBindAddress(this.getBindAddress());
        gemfireCacheServer.setHostNameForClients(this.getHostnameForClients());
        gemfireCacheServer.setListeners(this.getInterestRegistrationListeners());
        gemfireCacheServer.setLoadPollInterval(this.getLoadPollInterval());
        gemfireCacheServer.setMaxConnections(this.getMaxConnections());
        gemfireCacheServer.setMaxMessageCount(this.getMaxMessageCount());
        gemfireCacheServer.setMaxThreads(this.getMaxThreads());
        gemfireCacheServer.setMaxTimeBetweenPings(this.getMaxTimeBetweenPings());
        gemfireCacheServer.setMessageTimeToLive(this.getMessageTimeToLive());
        gemfireCacheServer.setPort(this.getPort());
        gemfireCacheServer.setServerLoadProbe(this.getServerLoadProbe());
        gemfireCacheServer.setSocketBufferSize(this.getSocketBufferSize());
        gemfireCacheServer.setSubscriptionCapacity(this.getSubscriptionCapacity());
        gemfireCacheServer.setSubscriptionDiskStore(this.getSubscriptionDiskStoreName());
        gemfireCacheServer.setSubscriptionEvictionPolicy(this.getSubscriptionEvictionPolicy());
        gemfireCacheServer.setTcpNoDelay(this.getTcpNoDelay());
        return gemfireCacheServer;
    }

    private List<CacheServerConfigurer> resolveCacheServerConfigurers() {
        return Optional.ofNullable(this.cacheServerConfigurers).filter(cacheServerConfigurers -> !cacheServerConfigurers.isEmpty()).orElseGet(() -> Optional.of(this.getBeanFactory()).filter(beanFactory -> beanFactory instanceof ListableBeanFactory).map(beanFactory -> {
            Map beansOfType = ((ListableBeanFactory)beanFactory).getBeansOfType(CacheServerConfigurer.class, true, true);
            return CollectionUtils.nullSafeMap(beansOfType).values().stream().collect(Collectors.toList());
        }).orElseGet(Collections::emptyList));
    }

    @Override
    protected void configureTheRest(AnnotationMetadata importMetadata) {
        super.configureCache(importMetadata);
        if (this.isCacheServerApplication(importMetadata)) {
            Map cacheServerApplicationAttributes = importMetadata.getAnnotationAttributes(this.getAnnotationTypeName());
            this.setAutoStartup(this.resolveProperty(this.cacheServerProperty("auto-startup"), Boolean.TRUE.equals(cacheServerApplicationAttributes.get("autoStartup"))));
            this.setBindAddress(this.resolveProperty(this.cacheServerProperty("bind-address"), (String)cacheServerApplicationAttributes.get("bindAddress")));
            this.setHostnameForClients(this.resolveProperty(this.cacheServerProperty("hostname-for-clients"), (String)cacheServerApplicationAttributes.get("hostnameForClients")));
            this.setLoadPollInterval(this.resolveProperty(this.cacheServerProperty("load-poll-interval"), (Long)cacheServerApplicationAttributes.get("loadPollInterval")));
            this.setMaxConnections(this.resolveProperty(this.cacheServerProperty("max-connections"), (Integer)cacheServerApplicationAttributes.get("maxConnections")));
            this.setMaxMessageCount(this.resolveProperty(this.cacheServerProperty("max-message-count"), (Integer)cacheServerApplicationAttributes.get("maxMessageCount")));
            this.setMaxThreads(this.resolveProperty(this.cacheServerProperty("max-threads"), (Integer)cacheServerApplicationAttributes.get("maxThreads")));
            this.setMaxTimeBetweenPings(this.resolveProperty(this.cacheServerProperty("max-time-between-pings"), (Integer)cacheServerApplicationAttributes.get("maxTimeBetweenPings")));
            this.setMessageTimeToLive(this.resolveProperty(this.cacheServerProperty("message-time-to-live"), (Integer)cacheServerApplicationAttributes.get("messageTimeToLive")));
            this.setPort(this.resolveProperty(this.cacheServerProperty("port"), (Integer)cacheServerApplicationAttributes.get("port")));
            this.setSocketBufferSize(this.resolveProperty(this.cacheServerProperty("socket-buffer-size"), (Integer)cacheServerApplicationAttributes.get("socketBufferSize")));
            this.setSubscriptionCapacity(this.resolveProperty(this.cacheServerProperty("subscription-capacity"), (Integer)cacheServerApplicationAttributes.get("subscriptionCapacity")));
            this.setSubscriptionDiskStoreName(this.resolveProperty(this.cacheServerProperty("subscription-disk-store-name"), (String)cacheServerApplicationAttributes.get("subscriptionDiskStoreName")));
            this.setSubscriptionEvictionPolicy(this.resolveProperty(this.cacheServerProperty("subscription-eviction-policy"), SubscriptionEvictionPolicy.class, (SubscriptionEvictionPolicy)((Object)cacheServerApplicationAttributes.get("subscriptionEvictionPolicy"))));
            this.setTcpNoDelay(this.resolveProperty(this.cacheServerProperty("tcp-no-delay"), (Boolean)cacheServerApplicationAttributes.get("tcpNoDelay")));
        }
    }

    protected Class getAnnotationType() {
        return CacheServerApplication.class;
    }

    void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    protected boolean isAutoStartup() {
        return this.autoStartup;
    }

    void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    protected String getBindAddress() {
        return Optional.ofNullable(this.bindAddress).filter(StringUtils::hasText).orElse("");
    }

    void setHostnameForClients(String hostnameForClients) {
        this.hostnameForClients = hostnameForClients;
    }

    protected String getHostnameForClients() {
        return Optional.ofNullable(this.hostnameForClients).filter(StringUtils::hasText).orElse("");
    }

    void setInterestRegistrationListeners(Set<InterestRegistrationListener> interestRegistrationListeners) {
        this.interestRegistrationListeners = interestRegistrationListeners;
    }

    protected Set<InterestRegistrationListener> getInterestRegistrationListeners() {
        return CollectionUtils.nullSafeSet(this.interestRegistrationListeners);
    }

    void setLoadPollInterval(Long loadPollInterval) {
        this.loadPollInterval = loadPollInterval;
    }

    protected Long getLoadPollInterval() {
        return Optional.ofNullable(this.loadPollInterval).orElse(5000L);
    }

    void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    protected Integer getMaxConnections() {
        return Optional.ofNullable(this.maxConnections).orElse(800);
    }

    void setMaxMessageCount(Integer maxMessageCount) {
        this.maxMessageCount = maxMessageCount;
    }

    protected Integer getMaxMessageCount() {
        return Optional.ofNullable(this.maxMessageCount).orElse(230000);
    }

    void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    protected Integer getMaxThreads() {
        return Optional.ofNullable(this.maxThreads).orElse(0);
    }

    void setMaxTimeBetweenPings(Integer maxTimeBetweenPings) {
        this.maxTimeBetweenPings = maxTimeBetweenPings;
    }

    protected Integer getMaxTimeBetweenPings() {
        return Optional.ofNullable(this.maxTimeBetweenPings).orElse(60000);
    }

    void setMessageTimeToLive(Integer messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
    }

    protected Integer getMessageTimeToLive() {
        return Optional.ofNullable(this.messageTimeToLive).orElse(180);
    }

    void setPort(Integer port) {
        this.port = port;
    }

    protected Integer getPort() {
        return Optional.ofNullable(this.port).orElse(40404);
    }

    void setServerLoadProbe(ServerLoadProbe serverLoadProbe) {
        this.serverLoadProbe = serverLoadProbe;
    }

    protected ServerLoadProbe getServerLoadProbe() {
        return Optional.ofNullable(this.serverLoadProbe).orElse(CacheServer.DEFAULT_LOAD_PROBE);
    }

    void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    protected Integer getSocketBufferSize() {
        return Optional.ofNullable(this.socketBufferSize).orElse(32768);
    }

    void setSubscriptionCapacity(Integer subscriptionCapacity) {
        this.subscriptionCapacity = subscriptionCapacity;
    }

    protected Integer getSubscriptionCapacity() {
        return Optional.ofNullable(this.subscriptionCapacity).orElse(1);
    }

    void setSubscriptionDiskStoreName(String subscriptionDiskStoreName) {
        this.subscriptionDiskStoreName = subscriptionDiskStoreName;
    }

    protected String getSubscriptionDiskStoreName() {
        return this.subscriptionDiskStoreName;
    }

    void setSubscriptionEvictionPolicy(SubscriptionEvictionPolicy subscriptionEvictionPolicy) {
        this.subscriptionEvictionPolicy = subscriptionEvictionPolicy;
    }

    protected SubscriptionEvictionPolicy getSubscriptionEvictionPolicy() {
        return Optional.ofNullable(this.subscriptionEvictionPolicy).orElse(SubscriptionEvictionPolicy.DEFAULT);
    }

    void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    protected Boolean getTcpNoDelay() {
        return Optional.ofNullable(this.tcpNoDelay).orElse(true);
    }

    @Override
    public String toString() {
        return DEFAULT_NAME;
    }
}

