/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.StringUtils;

public abstract class SpringUtils {
    public static BeanDefinition addDependsOn(BeanDefinition bean, String ... beanNames) {
        ArrayList<String> dependsOnList = new ArrayList<String>();
        Collections.addAll(dependsOnList, ArrayUtils.nullSafeArray(bean.getDependsOn(), String.class));
        dependsOnList.addAll(Arrays.asList(ArrayUtils.nullSafeArray(beanNames, String.class)));
        bean.setDependsOn(dependsOnList.toArray(new String[dependsOnList.size()]));
        return bean;
    }

    public static BeanDefinition setPropertyReference(BeanDefinition beanDefinition, String propertyName, String beanName) {
        beanDefinition.getPropertyValues().addPropertyValue(propertyName, (Object)new RuntimeBeanReference(beanName));
        return beanDefinition;
    }

    public static BeanDefinition setPropertyValue(BeanDefinition beanDefinition, String propertyName, Object propertyValue) {
        beanDefinition.getPropertyValues().addPropertyValue(propertyName, propertyValue);
        return beanDefinition;
    }

    public static String defaultIfEmpty(String value, String defaultValue) {
        return StringUtils.hasText((String)value) ? value : defaultValue;
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return Optional.ofNullable(value).orElse(defaultValue);
    }

    public static <T> T defaultIfNull(T value, Supplier<T> supplier) {
        return Optional.ofNullable(value).orElseGet(supplier);
    }

    public static String dereferenceBean(String beanName) {
        return String.format("%1$s%2$s", "&", beanName);
    }

    public static boolean equalsIgnoreNull(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static boolean nullOrEquals(Object obj1, Object obj2) {
        return obj1 == null || obj1.equals(obj2);
    }

    public static boolean nullSafeEquals(Object obj1, Object obj2) {
        return obj1 != null && obj1.equals(obj2);
    }

    public static <T> T safeGetValue(Supplier<T> valueSupplier) {
        return SpringUtils.safeGetValue(valueSupplier, null);
    }

    public static <T> T safeGetValue(Supplier<T> valueSupplier, T defaultValue) {
        return (T)SpringUtils.safeGetValue(valueSupplier, () -> defaultValue);
    }

    public static <T> T safeGetValue(Supplier<T> valueSupplier, Supplier<T> defaultValueSupplier) {
        return (T)SpringUtils.safeGetValue(valueSupplier, (Throwable exception) -> defaultValueSupplier.get());
    }

    public static <T> T safeGetValue(Supplier<T> valueSupplier, Function<Throwable, T> exceptionHandler) {
        try {
            return valueSupplier.get();
        }
        catch (Throwable cause) {
            return exceptionHandler.apply(cause);
        }
    }
}

