/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.pdx.PdxReader;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.PdxWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.GemfirePropertyValueProvider;
import org.springframework.data.gemfire.mapping.PdxReaderPropertyAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.util.Assert;

public class MappingPdxSerializer
implements PdxSerializer,
ApplicationContextAware {
    private final ConversionService conversionService;
    private EntityInstantiators instantiators;
    private final GemfireMappingContext mappingContext;
    protected final Log log = LogFactory.getLog(this.getClass());
    private Map<Class<?>, PdxSerializer> customSerializers;
    private SpELContext context;

    public static MappingPdxSerializer create(GemfireMappingContext mappingContext, ConversionService conversionService) {
        mappingContext = mappingContext != null ? mappingContext : new GemfireMappingContext();
        conversionService = conversionService != null ? conversionService : new DefaultConversionService();
        return new MappingPdxSerializer(mappingContext, conversionService);
    }

    public MappingPdxSerializer() {
        this(new GemfireMappingContext(), (ConversionService)new DefaultConversionService());
    }

    public MappingPdxSerializer(GemfireMappingContext mappingContext, ConversionService conversionService) {
        Assert.notNull((Object)((Object)mappingContext), (String)"GemfireMappingContext must not be null");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.mappingContext = mappingContext;
        this.conversionService = conversionService;
        this.instantiators = new EntityInstantiators();
        this.customSerializers = Collections.emptyMap();
        this.context = new SpELContext((PropertyAccessor)PdxReaderPropertyAccessor.INSTANCE);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = new SpELContext(this.context, (BeanFactory)applicationContext);
    }

    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setCustomSerializers(Map<Class<?>, PdxSerializer> customSerializers) {
        Assert.notNull(customSerializers, (String)"Custom PdxSerializers must not be null");
        this.customSerializers = customSerializers;
    }

    protected Map<Class<?>, PdxSerializer> getCustomSerializers() {
        return Collections.unmodifiableMap(this.customSerializers);
    }

    public void setGemfireInstantiators(Map<Class<?>, EntityInstantiator> gemfireInstantiators) {
        Assert.notNull(gemfireInstantiators, (String)"EntityInstantiators must not be null");
        this.instantiators = new EntityInstantiators(gemfireInstantiators);
    }

    protected EntityInstantiators getGemfireInstantiators() {
        return this.instantiators;
    }

    protected GemfireMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public Object fromData(Class<?> type, PdxReader reader) {
        GemfirePersistentEntity<?> entity = this.getPersistentEntity(type);
        Object instance = this.getInstantiatorFor((PersistentEntity)entity).createInstance(entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new GemfirePropertyValueProvider(reader), null));
        ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), this.getConversionService());
        entity.doWithProperties(arg_0 -> this.lambda$fromData$0(entity, instance, type, reader, (PersistentPropertyAccessor)propertyAccessor, arg_0));
        return propertyAccessor.getBean();
    }

    public boolean toData(Object value, PdxWriter writer) {
        GemfirePersistentEntity<?> entity = this.getPersistentEntity(value);
        ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(value), this.getConversionService());
        entity.doWithProperties(arg_0 -> this.lambda$toData$1((PersistentPropertyAccessor)propertyAccessor, value, writer, arg_0));
        GemfirePersistentProperty idProperty = (GemfirePersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            writer.markIdentityField(idProperty.getName());
        }
        return true;
    }

    protected PdxSerializer getCustomSerializer(Class<?> type) {
        return this.getCustomSerializers().get(type);
    }

    protected EntityInstantiator getInstantiatorFor(PersistentEntity entity) {
        return this.getGemfireInstantiators().getInstantiatorFor(entity);
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Object entity) {
        return this.getPersistentEntity(entity.getClass());
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Class<?> entityType) {
        return (GemfirePersistentEntity)this.getMappingContext().getPersistentEntity(entityType);
    }

    private /* synthetic */ void lambda$toData$1(PersistentPropertyAccessor propertyAccessor, Object value, PdxWriter writer, GemfirePersistentProperty persistentProperty) {
        PdxSerializer customSerializer = this.getCustomSerializer(persistentProperty.getType());
        Object propertyValue = null;
        try {
            propertyValue = propertyAccessor.getProperty((PersistentProperty)persistentProperty);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Serializing entity property [%1$s] value [%2$s] of type [%3$s] to PDX%4$s", persistentProperty.getName(), propertyValue, value.getClass(), customSerializer != null ? String.format(" using custom PdxSerializer [%s]", customSerializer) : ""));
            }
            if (customSerializer != null) {
                customSerializer.toData(propertyValue, writer);
            } else {
                writer.writeField(persistentProperty.getName(), propertyValue, persistentProperty.getType());
            }
        }
        catch (Exception e) {
            throw new MappingException(String.format("While serializing entity property [%1$s] value [%2$s] of type [%3$s] to PDX%4$s", persistentProperty.getName(), propertyValue, value.getClass(), customSerializer != null ? String.format(" using custom PdxSerializer [%1$s].", customSerializer.getClass().getName()) : "."), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$fromData$0(GemfirePersistentEntity entity, Object instance, Class type, PdxReader reader, PersistentPropertyAccessor propertyAccessor, GemfirePersistentProperty persistentProperty) {
        if (!entity.isConstructorArgument((PersistentProperty)persistentProperty)) {
            PdxSerializer customSerializer = this.getCustomSerializer(persistentProperty.getType());
            Object value = null;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Setting property [%1$s] for entity [%2$s] of type [%3$s] from PDX%4$s", persistentProperty.getName(), instance, type, customSerializer != null ? String.format(" using custom PdxSerializer [%1$s]", customSerializer) : ""));
                }
                Object object = value = customSerializer != null ? customSerializer.fromData(persistentProperty.getType(), reader) : reader.readField(persistentProperty.getName());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("... with value [%s]", value));
                }
                propertyAccessor.setProperty((PersistentProperty)persistentProperty, value);
            }
            catch (Exception e) {
                throw new MappingException(String.format("While setting value [%1$s] of property [%2$s] for entity of type [%3$s] from PDX%4$s", value, persistentProperty.getName(), type, customSerializer != null ? String.format(" using custom PdxSerializer [%14s]", customSerializer) : ""), (Throwable)e);
            }
        }
    }
}

