/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.query.QueryService;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.client.PoolAdapter;
import org.springframework.data.gemfire.config.annotation.PoolConfigurer;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public class PoolFactoryBean
extends AbstractFactoryBeanSupport<Pool>
implements DisposableBean,
InitializingBean {
    protected static final int DEFAULT_LOCATOR_PORT = 10334;
    protected static final int DEFAULT_SERVER_PORT = 40404;
    volatile boolean springBasedPool = true;
    private boolean keepAlive = false;
    private boolean multiUserAuthentication = false;
    private boolean prSingleHopEnabled = true;
    private boolean subscriptionEnabled = false;
    private boolean threadLocalConnections = false;
    private int freeConnectionTimeout = 10000;
    private int loadConditioningInterval = 300000;
    private int maxConnections = -1;
    private int minConnections = 1;
    private int readTimeout = 10000;
    private int retryAttempts = -1;
    private int socketBufferSize = 32768;
    private int statisticInterval = -1;
    private int subscriptionAckInterval = 100;
    private int subscriptionMessageTrackingTimeout = 900000;
    private int subscriptionRedundancy = 0;
    private long idleTimeout = 5000L;
    private long pingInterval = 10000L;
    private ConnectionEndpointList locators = new ConnectionEndpointList();
    private ConnectionEndpointList servers = new ConnectionEndpointList();
    private List<PoolConfigurer> poolConfigurers = Collections.emptyList();
    private volatile Pool pool;
    private PoolConfigurer compositePoolConfigurer = (beanName, bean) -> CollectionUtils.nullSafeCollection(this.poolConfigurers).forEach(poolConfigurer -> poolConfigurer.configure(beanName, bean));
    private PoolFactoryInitializer poolFactoryInitializer;
    private String name;
    private String serverGroup = "";

    public void afterPropertiesSet() throws Exception {
        this.init(Optional.ofNullable(PoolManager.find((String)this.validatePoolName())));
    }

    private void init(Optional<Pool> existingPool) {
        if (existingPool.isPresent()) {
            this.pool = existingPool.get();
            this.springBasedPool = false;
            this.logDebug(() -> String.format("Pool with name [%s] already exists; Using existing Pool; Pool Configurers [%d] will not be applied", ((Pool)existingPool.get()).getName(), this.poolConfigurers.size()));
        } else {
            this.springBasedPool = true;
            this.applyPoolConfigurers();
            this.logDebug("No Pool with name [%s] was found; Creating new Pool", this.getName());
        }
    }

    private void applyPoolConfigurers() {
        this.applyPoolConfigurers(this.getCompositePoolConfigurer());
    }

    protected void applyPoolConfigurers(PoolConfigurer ... poolConfigurers) {
        this.applyPoolConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(poolConfigurers, PoolConfigurer.class)));
    }

    protected void applyPoolConfigurers(Iterable<PoolConfigurer> poolConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(poolConfigurers).spliterator(), false).forEach(poolConfigurer -> poolConfigurer.configure(this.getName(), this));
    }

    private String validatePoolName() {
        if (!StringUtils.hasText((String)this.getName())) {
            this.setName(Optional.ofNullable(this.getBeanName()).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Pool name is required", new Object[0])));
        }
        return this.getName();
    }

    public void destroy() throws Exception {
        Optional.ofNullable(this.pool).filter(pool -> this.springBasedPool).filter(pool -> !pool.isDestroyed()).ifPresent(pool -> {
            pool.releaseThreadLocalConnection();
            pool.destroy(this.keepAlive);
            this.setPool(null);
            this.logDebug("Destroyed Pool [%s]", pool.getName());
        });
    }

    protected PoolConfigurer getCompositePoolConfigurer() {
        return this.compositePoolConfigurer;
    }

    public Pool getObject() throws Exception {
        return Optional.ofNullable(this.pool).orElseGet(() -> {
            this.eagerlyInitializeClientCacheIfNotPresent();
            Pool namedPool = PoolManager.find((String)this.getName());
            this.pool = namedPool != null ? namedPool : this.create(this.configure(this.initialize(this.createPoolFactory())), this.getName());
            return this.pool;
        });
    }

    boolean isDistributedSystemPresent() {
        return GemfireUtils.isConnected(GemfireUtils.getDistributedSystem());
    }

    private void eagerlyInitializeClientCacheIfNotPresent() {
        if (!this.isDistributedSystemPresent()) {
            this.getBeanFactory().getBean(ClientCache.class);
        }
    }

    protected PoolFactory createPoolFactory() {
        return PoolManager.createFactory();
    }

    protected PoolFactory configure(PoolFactory poolFactory) {
        Optional.ofNullable(poolFactory).ifPresent(it -> {
            it.setFreeConnectionTimeout(this.freeConnectionTimeout);
            it.setIdleTimeout(this.idleTimeout);
            it.setLoadConditioningInterval(this.loadConditioningInterval);
            it.setMaxConnections(this.maxConnections);
            it.setMinConnections(this.minConnections);
            it.setMultiuserAuthentication(this.multiUserAuthentication);
            it.setPingInterval(this.pingInterval);
            it.setPRSingleHopEnabled(this.prSingleHopEnabled);
            it.setReadTimeout(this.readTimeout);
            it.setRetryAttempts(this.retryAttempts);
            it.setServerGroup(this.serverGroup);
            it.setSocketBufferSize(this.socketBufferSize);
            it.setStatisticInterval(this.statisticInterval);
            it.setSubscriptionAckInterval(this.subscriptionAckInterval);
            it.setSubscriptionEnabled(this.subscriptionEnabled);
            it.setSubscriptionMessageTrackingTimeout(this.subscriptionMessageTrackingTimeout);
            it.setSubscriptionRedundancy(this.subscriptionRedundancy);
            it.setThreadLocalConnections(this.threadLocalConnections);
            CollectionUtils.nullSafeCollection(this.locators).forEach(locator -> it.addLocator(locator.getHost(), locator.getPort()));
            CollectionUtils.nullSafeCollection(this.servers).forEach(server -> it.addServer(server.getHost(), server.getPort()));
        });
        return poolFactory;
    }

    protected PoolFactory initialize(PoolFactory poolFactory) {
        return Optional.ofNullable(this.poolFactoryInitializer).map(initializer -> initializer.initialize(poolFactory)).orElse(poolFactory);
    }

    protected Pool create(PoolFactory poolFactory, String poolName) {
        return poolFactory.create(poolName);
    }

    public Class<?> getObjectType() {
        return Optional.ofNullable(this.pool).map(Object::getClass).orElse(Pool.class);
    }

    public void addLocators(ConnectionEndpoint ... locators) {
        this.locators.add(locators);
    }

    public void addLocators(Iterable<ConnectionEndpoint> locators) {
        this.locators.add(locators);
    }

    public void addServers(ConnectionEndpoint ... servers) {
        this.servers.add(servers);
    }

    public void addServers(Iterable<ConnectionEndpoint> servers) {
        this.servers.add(servers);
    }

    public void setName(String name) {
        this.name = name;
    }

    protected String getName() {
        return this.name;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public Pool getPool() {
        return Optional.ofNullable(this.pool).orElseGet(() -> new PoolAdapter(){

            @Override
            public boolean isDestroyed() {
                Pool pool = PoolFactoryBean.this.pool;
                return pool != null && pool.isDestroyed();
            }

            @Override
            public int getFreeConnectionTimeout() {
                return PoolFactoryBean.this.freeConnectionTimeout;
            }

            @Override
            public long getIdleTimeout() {
                return PoolFactoryBean.this.idleTimeout;
            }

            @Override
            public int getLoadConditioningInterval() {
                return PoolFactoryBean.this.loadConditioningInterval;
            }

            @Override
            public List<InetSocketAddress> getLocators() {
                return PoolFactoryBean.this.locators.toInetSocketAddresses();
            }

            @Override
            public List<InetSocketAddress> getOnlineLocators() {
                return Optional.ofNullable(PoolFactoryBean.this.pool).map(Pool::getOnlineLocators).orElseThrow(() -> new IllegalStateException("The Pool has not been initialized"));
            }

            @Override
            public int getMaxConnections() {
                return PoolFactoryBean.this.maxConnections;
            }

            @Override
            public int getMinConnections() {
                return PoolFactoryBean.this.minConnections;
            }

            @Override
            public boolean getMultiuserAuthentication() {
                return PoolFactoryBean.this.multiUserAuthentication;
            }

            @Override
            public String getName() {
                return Optional.ofNullable(PoolFactoryBean.this.getName()).filter(StringUtils::hasText).orElseGet(PoolFactoryBean.this::getBeanName);
            }

            @Override
            public int getPendingEventCount() {
                return Optional.ofNullable(PoolFactoryBean.this.pool).map(Pool::getPendingEventCount).orElseThrow(() -> new IllegalStateException("The Pool has not been initialized"));
            }

            @Override
            public long getPingInterval() {
                return PoolFactoryBean.this.pingInterval;
            }

            @Override
            public boolean getPRSingleHopEnabled() {
                return PoolFactoryBean.this.prSingleHopEnabled;
            }

            @Override
            public QueryService getQueryService() {
                return Optional.ofNullable(PoolFactoryBean.this.pool).map(Pool::getQueryService).orElseThrow(() -> new IllegalStateException("The Pool has not been initialized"));
            }

            @Override
            public int getReadTimeout() {
                return PoolFactoryBean.this.readTimeout;
            }

            @Override
            public int getRetryAttempts() {
                return PoolFactoryBean.this.retryAttempts;
            }

            @Override
            public String getServerGroup() {
                return PoolFactoryBean.this.serverGroup;
            }

            @Override
            public List<InetSocketAddress> getServers() {
                return PoolFactoryBean.this.servers.toInetSocketAddresses();
            }

            @Override
            public int getSocketBufferSize() {
                return PoolFactoryBean.this.socketBufferSize;
            }

            @Override
            public int getStatisticInterval() {
                return PoolFactoryBean.this.statisticInterval;
            }

            @Override
            public int getSubscriptionAckInterval() {
                return PoolFactoryBean.this.subscriptionAckInterval;
            }

            @Override
            public boolean getSubscriptionEnabled() {
                return PoolFactoryBean.this.subscriptionEnabled;
            }

            @Override
            public int getSubscriptionMessageTrackingTimeout() {
                return PoolFactoryBean.this.subscriptionMessageTrackingTimeout;
            }

            @Override
            public int getSubscriptionRedundancy() {
                return PoolFactoryBean.this.subscriptionRedundancy;
            }

            @Override
            public boolean getThreadLocalConnections() {
                return PoolFactoryBean.this.threadLocalConnections;
            }

            @Override
            public void destroy() {
                this.destroy(false);
            }

            @Override
            public void destroy(boolean keepAlive) {
                try {
                    PoolFactoryBean.this.destroy();
                }
                catch (Exception ignore) {
                    Optional.ofNullable(PoolFactoryBean.this.pool).ifPresent(pool -> pool.destroy(keepAlive));
                }
            }

            @Override
            public void releaseThreadLocalConnection() {
                Pool pool = PoolFactoryBean.this.pool;
                if (pool == null) {
                    throw new IllegalStateException("The Pool has not been initialized");
                }
                pool.releaseThreadLocalConnection();
            }
        });
    }

    public void setFreeConnectionTimeout(int freeConnectionTimeout) {
        this.freeConnectionTimeout = freeConnectionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setLoadConditioningInterval(int loadConditioningInterval) {
        this.loadConditioningInterval = loadConditioningInterval;
    }

    public void setLocators(ConnectionEndpoint[] connectionEndpoints) {
        this.setLocators(ConnectionEndpointList.from(connectionEndpoints));
    }

    public void setLocators(Iterable<ConnectionEndpoint> connectionEndpoints) {
        this.getLocators().clear();
        this.getLocators().add(connectionEndpoints);
    }

    ConnectionEndpointList getLocators() {
        return this.locators;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public void setMultiUserAuthentication(boolean multiUserAuthentication) {
        this.multiUserAuthentication = multiUserAuthentication;
    }

    public void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void setPoolConfigurers(PoolConfigurer ... poolConfigurers) {
        this.setPoolConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(poolConfigurers, PoolConfigurer.class)));
    }

    public void setPoolConfigurers(List<PoolConfigurer> poolConfigurers) {
        this.poolConfigurers = Optional.ofNullable(poolConfigurers).orElseGet(Collections::emptyList);
    }

    public void setPoolFactoryInitializer(PoolFactoryInitializer poolFactoryInitializer) {
        this.poolFactoryInitializer = poolFactoryInitializer;
    }

    public void setPrSingleHopEnabled(boolean prSingleHopEnabled) {
        this.prSingleHopEnabled = prSingleHopEnabled;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    public void setServers(ConnectionEndpoint[] connectionEndpoints) {
        this.setServers(ConnectionEndpointList.from(connectionEndpoints));
    }

    public void setServers(Iterable<ConnectionEndpoint> connectionEndpoints) {
        this.getServers().clear();
        this.getServers().add(connectionEndpoints);
    }

    ConnectionEndpointList getServers() {
        return this.servers;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setStatisticInterval(int statisticInterval) {
        this.statisticInterval = statisticInterval;
    }

    public void setSubscriptionAckInterval(int subscriptionAckInterval) {
        this.subscriptionAckInterval = subscriptionAckInterval;
    }

    public void setSubscriptionEnabled(boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    public void setSubscriptionMessageTrackingTimeout(int subscriptionMessageTrackingTimeout) {
        this.subscriptionMessageTrackingTimeout = subscriptionMessageTrackingTimeout;
    }

    public void setSubscriptionRedundancy(int subscriptionRedundancy) {
        this.subscriptionRedundancy = subscriptionRedundancy;
    }

    public void setThreadLocalConnections(boolean threadLocalConnections) {
        this.threadLocalConnections = threadLocalConnections;
    }

    public final void setLocatorsConfiguration(Object locatorsConfiguration) {
    }

    public final void setServersConfiguration(Object serversConfiguration) {
    }

    public static interface PoolFactoryInitializer {
        public PoolFactory initialize(PoolFactory var1);
    }
}

