/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.Collection;
import java.util.Collections;
import org.apache.geode.cache.query.SelectResults;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class StringBasedGemfireRepositoryQuery
extends GemfireRepositoryQuery {
    private static final String INVALID_QUERY = "Paging and modifying queries are not supported";
    private boolean userDefinedQuery = false;
    private final GemfireTemplate template;
    private final QueryString query;

    StringBasedGemfireRepositoryQuery() {
        this.query = null;
        this.template = null;
    }

    public StringBasedGemfireRepositoryQuery(GemfireQueryMethod queryMethod, GemfireTemplate template) {
        this(queryMethod.getAnnotatedQuery(), queryMethod, template);
    }

    public StringBasedGemfireRepositoryQuery(String query, GemfireQueryMethod queryMethod, GemfireTemplate template) {
        super(queryMethod);
        Assert.notNull((Object)template, (String)"GemfireTemplate must not be null");
        this.userDefinedQuery |= !StringUtils.hasText((String)query);
        this.query = new QueryString(StringUtils.hasText((String)query) ? query : queryMethod.getAnnotatedQuery());
        this.template = template;
        if (queryMethod.isModifyingQuery() || queryMethod.isPageQuery()) {
            throw new IllegalStateException(INVALID_QUERY);
        }
    }

    public StringBasedGemfireRepositoryQuery asUserDefinedQuery() {
        this.userDefinedQuery = true;
        return this;
    }

    public boolean isUserDefinedQuery() {
        return this.userDefinedQuery;
    }

    public Object execute(Object[] parameters) {
        QueryMethod localQueryMethod = this.getQueryMethod();
        QueryString query = this.isUserDefinedQuery() ? this.query : this.query.forRegion(localQueryMethod.getEntityInformation().getJavaType(), this.template.getRegion());
        ParametersParameterAccessor parameterAccessor = new ParametersParameterAccessor(localQueryMethod.getParameters(), parameters);
        for (Integer index : query.getInParameterIndexes()) {
            query = query.bindIn(this.toCollection(parameterAccessor.getBindableValue(index - 1)));
        }
        query = this.applyQueryAnnotationExtensions(localQueryMethod, query);
        Collection<?> result = this.toCollection(this.template.find(query.toString(), parameters));
        if (localQueryMethod.isCollectionQuery()) {
            return result;
        }
        if (localQueryMethod.isQueryForEntity()) {
            if (result.isEmpty()) {
                return null;
            }
            if (result.size() == 1) {
                return result.iterator().next();
            }
            throw new IncorrectResultSizeDataAccessException(1, result.size());
        }
        if (this.isSingleResultNonEntityQuery(localQueryMethod, result)) {
            return result.iterator().next();
        }
        throw new IllegalStateException("Unsupported query: " + query.toString());
    }

    QueryString applyQueryAnnotationExtensions(QueryMethod queryMethod, QueryString queryString) {
        QueryString resolvedQueryString = queryString;
        if (queryMethod instanceof GemfireQueryMethod) {
            GemfireQueryMethod gemfireQueryMethod = (GemfireQueryMethod)queryMethod;
            String query = queryString.toString().toUpperCase();
            if (gemfireQueryMethod.hasImport() && !QueryString.IMPORT_PATTERN.matcher(query).find()) {
                resolvedQueryString = resolvedQueryString.withImport(gemfireQueryMethod.getImport());
            }
            if (gemfireQueryMethod.hasHint() && !QueryString.HINT_PATTERN.matcher(query).find()) {
                resolvedQueryString = resolvedQueryString.withHints(gemfireQueryMethod.getHints());
            }
            if (gemfireQueryMethod.hasLimit() && !QueryString.LIMIT_PATTERN.matcher(query).find()) {
                resolvedQueryString = resolvedQueryString.withLimit(gemfireQueryMethod.getLimit());
            }
            if (gemfireQueryMethod.hasTrace() && !QueryString.TRACE_PATTERN.matcher(query).find()) {
                resolvedQueryString = resolvedQueryString.withTrace();
            }
        }
        return resolvedQueryString;
    }

    boolean isSingleResultNonEntityQuery(QueryMethod method, Collection<?> result) {
        return !method.isCollectionQuery() && method.getReturnedObjectType() != null && !Void.TYPE.equals(method.getReturnedObjectType()) && result != null && result.size() == 1;
    }

    Collection<?> toCollection(Object source) {
        if (source instanceof SelectResults) {
            return ((SelectResults)source).asList();
        }
        if (source instanceof Collection) {
            return (Collection)source;
        }
        if (source == null) {
            return Collections.emptyList();
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singletonList(source);
    }
}

