/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.Assert;

public abstract class CollectionUtils
extends org.springframework.util.CollectionUtils {
    public static <E, T extends Collection<E>> T addAll(T collection, Iterable<E> iterable) {
        Assert.notNull(collection, (String)"Collection must not be null");
        for (E element : CollectionUtils.nullSafeIterable(iterable)) {
            collection.add(element);
        }
        return collection;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... elements) {
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return Collections.unmodifiableSet(set);
    }

    public static boolean containsAny(Collection<?> collection, Object ... elements) {
        if (collection != null) {
            for (Object element : ArrayUtils.nullSafeArray(elements, Object.class)) {
                if (!collection.contains(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static <E, T extends Iterable<E>> T defaultIfEmpty(T iterable, T defaultIterable) {
        return iterable != null && iterable.iterator().hasNext() ? iterable : defaultIterable;
    }

    public static <T> Iterable<T> emptyIterable() {
        return CollectionUtils.nullSafeIterable(null);
    }

    public static <T> Iterable<T> iterable(Enumeration<T> enumeration) {
        return () -> CollectionUtils.toIterator((Enumeration)enumeration);
    }

    public static <T> Iterable<T> iterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    public static <T> Collection<T> nullSafeCollection(Collection<T> collection) {
        return collection != null ? collection : Collections.emptyList();
    }

    public static <T> Iterable<T> nullSafeIterable(Iterable<T> iterable) {
        return iterable != null ? iterable : Collections::emptyIterator;
    }

    public static <T> List<T> nullSafeList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    public static <K, V> Map<K, V> nullSafeMap(Map<K, V> map) {
        return map != null ? map : Collections.emptyMap();
    }

    public static <T> Set<T> nullSafeSet(Set<T> set) {
        return set != null ? set : Collections.emptySet();
    }

    public static <T extends Comparable<T>> List<T> sort(List<T> list) {
        Collections.sort(list);
        return list;
    }

    public static <T> List<T> subList(List<T> source, int ... indices) {
        Assert.notNull(source, (String)"List must not be null");
        ArrayList<T> result = new ArrayList<T>(indices.length);
        for (int index : indices) {
            result.add(source.get(index));
        }
        return result;
    }

    public static String toString(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder("{\n");
        int count = 0;
        for (Map.Entry<?, ?> entry : new TreeMap(map).entrySet()) {
            builder.append(++count > 1 ? ",\n" : "");
            builder.append("\t");
            builder.append(entry.getKey());
            builder.append(" = ");
            builder.append(entry.getValue());
        }
        builder.append("\n}");
        return builder.toString();
    }
}

