/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.util.Map;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.util.Assert;

class FunctionExecutionConfiguration {
    private Class<?> functionExecutionInterface;
    private final Map<String, Object> attributes;
    private final String annotationType;

    FunctionExecutionConfiguration() {
        this.annotationType = null;
        this.attributes = null;
    }

    FunctionExecutionConfiguration(ScannedGenericBeanDefinition beanDefinition, String annotationType) {
        try {
            this.annotationType = annotationType;
            this.attributes = beanDefinition.getMetadata().getAnnotationAttributes(annotationType, true);
            this.functionExecutionInterface = beanDefinition.resolveBeanClass(beanDefinition.getClass().getClassLoader());
            Assert.isTrue((boolean)this.functionExecutionInterface.isInterface(), (String)String.format("The annotation %1$s only applies to an interface. It is not valid for the type %2$s", annotationType, this.functionExecutionInterface.getName()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    String getAnnotationType() {
        return this.annotationType;
    }

    Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    Map<String, Object> getAttributes() {
        return this.attributes;
    }

    Class<?> getFunctionExecutionInterface() {
        return this.functionExecutionInterface;
    }
}

