/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.concurrent.Callable;
import org.apache.geode.cache.Region;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class GemfireCache
implements Cache {
    private final Region region;

    public static GemfireCache wrap(Region<?, ?> region) {
        return new GemfireCache(region);
    }

    public GemfireCache(Region<?, ?> region) {
        Assert.notNull(region, (String)"GemFire Region must not be null");
        this.region = region;
    }

    public Region getNativeCache() {
        return this.region;
    }

    public String getName() {
        return this.getNativeCache().getName();
    }

    public void clear() {
        this.getNativeCache().clear();
    }

    public void evict(Object key) {
        this.getNativeCache().remove(key);
    }

    public Cache.ValueWrapper get(Object key) {
        Object value = this.getNativeCache().get(key);
        return value != null ? new SimpleValueWrapper(value) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.getNativeCache().get(key);
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException(String.format("Cached value [%1$s] is not an instance of type [%2$s]", value, type.getName()));
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        Object value = this.get(key, Object.class);
        if (value == null) {
            Region region = this.getNativeCache();
            synchronized (region) {
                value = this.get(key, Object.class);
                if (value == null) {
                    try {
                        value = valueLoader.call();
                        this.put(key, value);
                    }
                    catch (Exception e) {
                        throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
                    }
                }
            }
        }
        return (T)value;
    }

    public void put(Object key, Object value) {
        if (value != null) {
            this.getNativeCache().put(key, value);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object existingValue = this.getNativeCache().putIfAbsent(key, value);
        return existingValue != null ? new SimpleValueWrapper(existingValue) : null;
    }
}

