/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.apache.geode.cache.Region;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.repository.support.GemfireRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class GemfireRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationContextAware {
    private Iterable<Region<?, ?>> regions;
    private MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection regions = applicationContext.getBeansOfType(Region.class).values();
        this.regions = Collections.unmodifiableCollection(regions);
    }

    public void setGemfireMappingContext(MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext) {
        this.setMappingContext(mappingContext);
        this.mappingContext = mappingContext;
    }

    protected MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> getGemfireMappingContext() {
        return this.mappingContext;
    }

    protected Iterable<Region<?, ?>> getRegions() {
        return this.regions;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return new GemfireRepositoryFactory(this.getRegions(), this.getGemfireMappingContext());
    }

    public void afterPropertiesSet() {
        Assert.state((this.getGemfireMappingContext() != null ? 1 : 0) != 0, (String)"GemfireMappingContext must not be null");
        super.afterPropertiesSet();
    }
}

