/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.FixedPartitionAttributesFactoryBean;
import org.springframework.data.gemfire.PartitionAttributesFactoryBean;
import org.springframework.data.gemfire.PartitionedRegionFactoryBean;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.config.xml.AbstractRegionParser;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class PartitionedRegionParser
extends AbstractRegionParser {
    PartitionedRegionParser() {
    }

    @Override
    protected Class<?> getRegionFactoryClass() {
        return PartitionedRegionFactoryBean.class;
    }

    @Override
    protected void doParseRegion(Element element, ParserContext parserContext, BeanDefinitionBuilder regionBuilder, boolean subRegion) {
        List fixedPartitionSubElements;
        Element partitionListenerSubElement;
        this.validateDataPolicyShortcutAttributesMutualExclusion(element, parserContext);
        BeanDefinitionBuilder regionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
        this.doParseRegionConfiguration(element, parserContext, regionBuilder, regionAttributesBuilder, subRegion);
        regionBuilder.addPropertyValue("attributes", (Object)regionAttributesBuilder.getBeanDefinition());
        BeanDefinitionBuilder partitionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(PartitionAttributesFactoryBean.class);
        this.mergeTemplateRegionPartitionAttributes(element, parserContext, regionBuilder, partitionAttributesBuilder);
        this.parseColocatedWith(element, regionBuilder, partitionAttributesBuilder, "colocated-with");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "copies", "redundantCopies");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "local-max-memory");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "recovery-delay");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "startup-recovery-delay");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "total-buckets", "totalNumBuckets");
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, "total-max-memory");
        Element partitionResolverSubElement = DomUtils.getChildElementByTagName((Element)element, (String)"partition-resolver");
        if (partitionResolverSubElement != null) {
            partitionAttributesBuilder.addPropertyValue("partitionResolver", this.parsePartitionResolver(partitionResolverSubElement, parserContext, regionBuilder));
        }
        if ((partitionListenerSubElement = DomUtils.getChildElementByTagName((Element)element, (String)"partition-listener")) != null) {
            partitionAttributesBuilder.addPropertyValue("partitionListeners", this.parsePartitionListeners(partitionListenerSubElement, parserContext, regionBuilder));
        }
        if (!CollectionUtils.isEmpty((Collection)(fixedPartitionSubElements = DomUtils.getChildElementsByTagName((Element)element, (String)"fixed-partition")))) {
            ManagedList fixedPartitionAttributes = new ManagedList();
            for (Element fixedPartition : fixedPartitionSubElements) {
                BeanDefinitionBuilder fixedPartitionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(FixedPartitionAttributesFactoryBean.class);
                ParsingUtils.setPropertyValue(fixedPartition, fixedPartitionAttributesBuilder, "partition-name");
                ParsingUtils.setPropertyValue(fixedPartition, fixedPartitionAttributesBuilder, "num-buckets");
                ParsingUtils.setPropertyValue(fixedPartition, fixedPartitionAttributesBuilder, "primary");
                fixedPartitionAttributes.add((Object)fixedPartitionAttributesBuilder.getBeanDefinition());
            }
            partitionAttributesBuilder.addPropertyValue("fixedPartitionAttributes", (Object)fixedPartitionAttributes);
        }
        regionAttributesBuilder.addPropertyValue("partitionAttributes", (Object)partitionAttributesBuilder.getBeanDefinition());
    }

    void mergeTemplateRegionPartitionAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder regionBuilder, BeanDefinitionBuilder partitionAttributesBuilder) {
        String regionTemplateName = this.getParentName(element);
        if (StringUtils.hasText((String)regionTemplateName)) {
            if (parserContext.getRegistry().containsBeanDefinition(regionTemplateName)) {
                PropertyValue partitionAttributesProperty;
                Object partitionAttributes;
                BeanDefinition templateRegion = parserContext.getRegistry().getBeanDefinition(regionTemplateName);
                BeanDefinition templateRegionAttributes = this.getRegionAttributesBeanDefinition(templateRegion);
                if (templateRegionAttributes != null && templateRegionAttributes.getPropertyValues().contains("partitionAttributes") && (partitionAttributes = (partitionAttributesProperty = templateRegionAttributes.getPropertyValues().getPropertyValue("partitionAttributes")).getValue()) instanceof BeanDefinition) {
                    partitionAttributesBuilder.getRawBeanDefinition().overrideFrom((BeanDefinition)partitionAttributes);
                }
            } else {
                parserContext.getReaderContext().error(String.format("The Region template [%1$s] must be 'defined before' the Region [%2$s] referring to the template!", regionTemplateName, this.resolveId(element, regionBuilder.getRawBeanDefinition(), parserContext)), (Object)element);
            }
        }
    }

    private void parseColocatedWith(Element element, BeanDefinitionBuilder regionBuilder, BeanDefinitionBuilder partitionAttributesBuilder, String attributeName) {
        ParsingUtils.setPropertyValue(element, partitionAttributesBuilder, attributeName);
        String colocatedWithBeanAlias = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)colocatedWithBeanAlias)) {
            regionBuilder.addDependsOn(colocatedWithBeanAlias);
        }
    }

    private Object parsePartitionResolver(Element subElement, ParserContext parserContext, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, subElement, builder);
    }

    private Object parsePartitionListeners(Element subElement, ParserContext parserContext, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, builder);
    }
}

