/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.wan.GatewaySender;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.LookupRegionFactoryBean;
import org.springframework.data.gemfire.config.xml.AbstractRegionParser;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class LookupRegionParser
extends AbstractRegionParser {
    LookupRegionParser() {
    }

    @Override
    protected Class<?> getRegionFactoryClass() {
        return LookupRegionFactoryBean.class;
    }

    @Override
    protected void doParseRegion(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, boolean subRegion) {
        Element cacheWriterElement;
        Element cacheLoaderElement;
        super.doParse(element, builder);
        String resolvedCacheRef = ParsingUtils.resolveCacheReference(element.getAttribute("cache-ref"));
        builder.addPropertyReference("cache", resolvedCacheRef);
        ParsingUtils.setPropertyValue(element, builder, "cloning-enabled");
        ParsingUtils.setPropertyValue(element, builder, "eviction-maximum");
        ParsingUtils.setPropertyValue(element, builder, "name");
        ParsingUtils.parseExpiration(parserContext, element, builder);
        this.parseCollectionOfCustomSubElements(element, parserContext, builder, AsyncEventQueue.class.getName(), "async-event-queue", "asyncEventQueues");
        this.parseCollectionOfCustomSubElements(element, parserContext, builder, GatewaySender.class.getName(), "gateway-sender", "gatewaySenders");
        Element cacheListenerElement = DomUtils.getChildElementByTagName((Element)element, (String)"cache-listener");
        if (cacheListenerElement != null) {
            builder.addPropertyValue("cacheListeners", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, cacheListenerElement, builder));
        }
        if ((cacheLoaderElement = DomUtils.getChildElementByTagName((Element)element, (String)"cache-loader")) != null) {
            builder.addPropertyValue("cacheLoader", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, cacheLoaderElement, builder));
        }
        if ((cacheWriterElement = DomUtils.getChildElementByTagName((Element)element, (String)"cache-writer")) != null) {
            builder.addPropertyValue("cacheWriter", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, cacheWriterElement, builder));
        }
        if (!subRegion) {
            this.parseSubRegions(element, parserContext, resolvedCacheRef);
        }
    }
}

