/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableSsl;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;
import org.springframework.util.Assert;

public class SslConfiguration
extends EmbeddedServiceConfigurationSupport {
    @Override
    protected Class getAnnotationType() {
        return EnableSsl.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = new PropertiesBuilder();
        EnableSsl.Component[] components = (EnableSsl.Component[])annotationAttributes.get("components");
        Assert.notNull((Object)components, (String)"GemFire SSL enabled components cannot be null");
        for (EnableSsl.Component component : components) {
            gemfireProperties.setProperty(String.format("%s-ssl-ciphers", new Object[]{component}), annotationAttributes.get("ciphers")).setProperty(String.format("%s-ssl-enabled", new Object[]{component}), Boolean.TRUE.toString()).setProperty(String.format("%s-ssl-keystore", new Object[]{component}), annotationAttributes.get("keystore")).setProperty(String.format("%s-ssl-keystore-password", new Object[]{component}), annotationAttributes.get("keystorePassword")).setProperty(String.format("%s-ssl-keystore-type", new Object[]{component}), annotationAttributes.get("keystoreType")).setProperty(String.format("%s-ssl-protocols", new Object[]{component}), annotationAttributes.get("protocols")).setProperty(String.format("%s-ssl-require-authentication", new Object[]{component}), Boolean.TRUE.equals(annotationAttributes.get("requireAuthentication"))).setProperty(String.format("%s-ssl-truststore", new Object[]{component}), annotationAttributes.get("truststore")).setProperty(String.format("%s-ssl-truststore-password", new Object[]{component}), annotationAttributes.get("truststorePassword"));
        }
        return gemfireProperties.build();
    }
}

