/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.pdx.PdxSerializer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.CacheServerApplication;
import org.springframework.data.gemfire.config.annotation.ClientCacheApplication;
import org.springframework.data.gemfire.config.annotation.EnablePdx;
import org.springframework.data.gemfire.config.annotation.PeerCacheApplication;
import org.springframework.data.gemfire.config.support.CustomEditorBeanFactoryPostProcessor;
import org.springframework.data.gemfire.config.support.DefinedIndexesApplicationListener;
import org.springframework.data.gemfire.config.support.DiskStoreDirectoryBeanPostProcessor;
import org.springframework.data.gemfire.config.support.PdxDiskStoreAwareBeanFactoryPostProcessor;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.MappingPdxSerializer;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.PropertiesBuilder;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
public abstract class AbstractCacheConfiguration
implements BeanClassLoaderAware,
BeanFactoryAware,
ImportAware {
    private static final AtomicBoolean CUSTOM_EDITORS_REGISTERED = new AtomicBoolean(false);
    private static final AtomicBoolean DEFINED_INDEXES_APPLICATION_LISTENER_REGISTERED = new AtomicBoolean(false);
    private static final AtomicBoolean DISK_STORE_DIRECTORY_BEAN_POST_PROCESSOR_REGISTERED = new AtomicBoolean(false);
    private static final AtomicBoolean PDX_DISK_STORE_AWARE_BEAN_FACTORY_POST_PROCESSOR_REGISTERED = new AtomicBoolean(false);
    protected static final boolean DEFAULT_CLOSE = true;
    protected static final boolean DEFAULT_COPY_ON_READ = false;
    protected static final boolean DEFAULT_USE_BEAN_FACTORY_LOCATOR = false;
    protected static final int DEFAULT_MCAST_PORT = 0;
    protected static final String DEFAULT_LOCATORS = "";
    protected static final String DEFAULT_LOG_LEVEL = "config";
    protected static final String DEFAULT_NAME = "SpringDataGemFireApplication";
    private boolean close = true;
    private boolean copyOnRead = false;
    private boolean useBeanFactoryLocator = false;
    private BeanFactory beanFactory;
    private Boolean pdxIgnoreUnreadFields;
    private Boolean pdxPersistent;
    private Boolean pdxReadSerialized;
    private ClassLoader beanClassLoader;
    private CacheFactoryBean.DynamicRegionSupport dynamicRegionSupport;
    private Integer mcastPort = 0;
    private Float criticalHeapPercentage;
    private Float evictionHeapPercentage;
    private GatewayConflictResolver gatewayConflictResolver;
    @Autowired(required=false)
    private GemfireMappingContext mappingContext;
    private List<CacheFactoryBean.JndiDataSource> jndiDataSources;
    private List<TransactionListener> transactionListeners;
    private PdxSerializer pdxSerializer;
    private PropertiesBuilder customGemFireProperties = PropertiesBuilder.create();
    private Resource cacheXml;
    private String locators = "";
    private String logLevel = "config";
    private String name;
    private String pdxDiskStoreName;
    private String startLocator;
    private TransactionWriter transactionWriter;

    protected static boolean hasValue(Object value) {
        return value != null;
    }

    protected static boolean hasValue(Number value) {
        return value != null && value.doubleValue() != 0.0;
    }

    protected static boolean hasValue(String value) {
        return StringUtils.hasText((String)value);
    }

    @Bean
    protected Properties gemfireProperties() {
        PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
        gemfireProperties.setProperty("name", this.name());
        gemfireProperties.setProperty("mcast-port", this.mcastPort());
        gemfireProperties.setProperty("log-level", this.logLevel());
        gemfireProperties.setProperty("locators", this.locators());
        gemfireProperties.setProperty("start-locator", this.startLocator());
        gemfireProperties.add(this.customGemFireProperties);
        return gemfireProperties.build();
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    protected ClassLoader beanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory beanFactory() {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory was not properly initialized");
        return this.beanFactory;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.configureInfrastructure(importMetadata);
        this.configureCache(importMetadata);
        this.configurePdx(importMetadata);
        this.configureOther(importMetadata);
    }

    protected void configureInfrastructure(AnnotationMetadata importMetadata) {
        this.registerCustomEditorBeanFactoryPostProcessor(importMetadata);
        this.registerDefinedIndexesApplicationListener(importMetadata);
        this.registerDiskStoreDirectoryBeanPostProcessor(importMetadata);
    }

    protected void configureCache(AnnotationMetadata importMetadata) {
        if (this.isClientPeerOrServerCacheApplication(importMetadata)) {
            Float evictionHeapPercentage;
            Map cacheMetadataAttributes = importMetadata.getAnnotationAttributes(this.getAnnotationTypeName());
            this.setCopyOnRead(Boolean.TRUE.equals(cacheMetadataAttributes.get("copyOnRead")));
            Float criticalHeapPercentage = (Float)cacheMetadataAttributes.get("criticalHeapPercentage");
            if (AbstractCacheConfiguration.hasValue(criticalHeapPercentage)) {
                this.setCriticalHeapPercentage(criticalHeapPercentage);
            }
            if (AbstractCacheConfiguration.hasValue(evictionHeapPercentage = (Float)cacheMetadataAttributes.get("evictionHeapPercentage"))) {
                this.setEvictionHeapPercentage(evictionHeapPercentage);
            }
            this.setLogLevel((String)cacheMetadataAttributes.get("logLevel"));
            this.setName((String)cacheMetadataAttributes.get("name"));
            this.setUseBeanFactoryLocator(Boolean.TRUE.equals(cacheMetadataAttributes.get("useBeanFactoryLocator")));
        }
    }

    protected void configurePdx(AnnotationMetadata importMetadata) {
        String enablePdxTypeName = EnablePdx.class.getName();
        if (importMetadata.hasAnnotation(enablePdxTypeName)) {
            Map enablePdxAttributes = importMetadata.getAnnotationAttributes(enablePdxTypeName);
            this.setPdxDiskStoreName((String)enablePdxAttributes.get("diskStoreName"));
            this.setPdxIgnoreUnreadFields(Boolean.TRUE.equals(enablePdxAttributes.get("ignoreUnreadFields")));
            this.setPdxPersistent(Boolean.TRUE.equals(enablePdxAttributes.get("persistent")));
            this.setPdxReadSerialized(Boolean.TRUE.equals(enablePdxAttributes.get("readSerialized")));
            this.setPdxSerializer(this.resolvePdxSerializer((String)enablePdxAttributes.get("serializerBeanName")));
            this.registerPdxDiskStoreAwareBeanFactoryPostProcessor(importMetadata);
        }
    }

    protected void configureOther(AnnotationMetadata importMetadata) {
    }

    protected PdxSerializer resolvePdxSerializer(String pdxSerializerBeanName) {
        BeanFactory beanFactory = this.beanFactory();
        PdxSerializer pdxSerializer = this.pdxSerializer();
        return beanFactory.containsBean(pdxSerializerBeanName) ? (PdxSerializer)beanFactory.getBean(pdxSerializerBeanName, PdxSerializer.class) : (pdxSerializer != null ? pdxSerializer : this.newPdxSerializer());
    }

    protected <T extends PdxSerializer> T newPdxSerializer() {
        BeanFactory beanFactory = this.beanFactory();
        ConversionService conversionService = beanFactory instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)beanFactory).getConversionService() : null;
        return (T)MappingPdxSerializer.create(this.mappingContext, conversionService);
    }

    protected void registerCustomEditorBeanFactoryPostProcessor(AnnotationMetadata importMetadata) {
        if (CUSTOM_EDITORS_REGISTERED.compareAndSet(false, true)) {
            this.register(BeanDefinitionBuilder.rootBeanDefinition(CustomEditorBeanFactoryPostProcessor.class).setRole(2).getBeanDefinition());
        }
    }

    protected void registerDefinedIndexesApplicationListener(AnnotationMetadata importMetadata) {
        if (DEFINED_INDEXES_APPLICATION_LISTENER_REGISTERED.compareAndSet(false, true)) {
            this.register(BeanDefinitionBuilder.rootBeanDefinition(DefinedIndexesApplicationListener.class).setRole(2).getBeanDefinition());
        }
    }

    protected void registerDiskStoreDirectoryBeanPostProcessor(AnnotationMetadata importMetadata) {
        if (DISK_STORE_DIRECTORY_BEAN_POST_PROCESSOR_REGISTERED.compareAndSet(false, true)) {
            this.register(BeanDefinitionBuilder.rootBeanDefinition(DiskStoreDirectoryBeanPostProcessor.class).setRole(2).getBeanDefinition());
        }
    }

    protected void registerPdxDiskStoreAwareBeanFactoryPostProcessor(AnnotationMetadata importMetadata) {
        if (StringUtils.hasText((String)this.pdxDiskStoreName()) && PDX_DISK_STORE_AWARE_BEAN_FACTORY_POST_PROCESSOR_REGISTERED.compareAndSet(false, true)) {
            this.register(BeanDefinitionBuilder.rootBeanDefinition(PdxDiskStoreAwareBeanFactoryPostProcessor.class).setRole(2).addConstructorArgValue((Object)this.pdxDiskStoreName()).getBeanDefinition());
        }
    }

    protected AbstractBeanDefinition register(AbstractBeanDefinition beanDefinition) {
        if (this.beanFactory() instanceof BeanDefinitionRegistry) {
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)((BeanDefinitionRegistry)this.beanFactory()));
        }
        return beanDefinition;
    }

    protected abstract Class getAnnotationType();

    protected String getAnnotationTypeName() {
        return this.getAnnotationType().getName();
    }

    protected String getAnnotationTypeSimpleName() {
        return this.getAnnotationType().getSimpleName();
    }

    protected boolean isCacheServerApplication(AnnotationMetadata importMetadata) {
        return this.isTypedCacheApplication(CacheServerApplication.class, importMetadata);
    }

    protected boolean isClientCacheApplication(AnnotationMetadata importMetadata) {
        return this.isTypedCacheApplication(ClientCacheApplication.class, importMetadata);
    }

    protected boolean isPeerCacheApplication(AnnotationMetadata importMetadata) {
        return this.isTypedCacheApplication(PeerCacheApplication.class, importMetadata);
    }

    protected boolean isTypedCacheApplication(Class<? extends Annotation> annotationType, AnnotationMetadata importMetadata) {
        return annotationType.equals(this.getAnnotationType()) && importMetadata.hasAnnotation(this.getAnnotationTypeName());
    }

    protected boolean isCacheServerOrPeerCacheApplication(AnnotationMetadata importMetadata) {
        return this.isCacheServerApplication(importMetadata) || this.isPeerCacheApplication(importMetadata);
    }

    protected boolean isClientPeerOrServerCacheApplication(AnnotationMetadata importMetadata) {
        return this.isCacheServerApplication(importMetadata) || this.isClientCacheApplication(importMetadata) || this.isPeerCacheApplication(importMetadata);
    }

    protected <T extends CacheFactoryBean> T constructCacheFactoryBean() {
        return this.setCommonCacheConfiguration(this.newCacheFactoryBean());
    }

    protected abstract <T extends CacheFactoryBean> T newCacheFactoryBean();

    protected <T extends CacheFactoryBean> T setCommonCacheConfiguration(T gemfireCache) {
        gemfireCache.setBeanClassLoader(this.beanClassLoader());
        gemfireCache.setBeanFactory(this.beanFactory());
        gemfireCache.setCacheXml(this.cacheXml());
        gemfireCache.setClose(this.close());
        gemfireCache.setCopyOnRead(this.copyOnRead());
        gemfireCache.setCriticalHeapPercentage(this.criticalHeapPercentage());
        gemfireCache.setDynamicRegionSupport(this.dynamicRegionSupport());
        gemfireCache.setEvictionHeapPercentage(this.evictionHeapPercentage());
        gemfireCache.setGatewayConflictResolver(this.gatewayConflictResolver());
        gemfireCache.setJndiDataSources(this.jndiDataSources());
        gemfireCache.setProperties(this.gemfireProperties());
        gemfireCache.setPdxDiskStoreName(this.pdxDiskStoreName());
        gemfireCache.setPdxIgnoreUnreadFields(this.pdxIgnoreUnreadFields());
        gemfireCache.setPdxPersistent(this.pdxPersistent());
        gemfireCache.setPdxReadSerialized(this.pdxReadSerialized());
        gemfireCache.setPdxSerializer(this.pdxSerializer());
        gemfireCache.setTransactionListeners(this.transactionListeners());
        gemfireCache.setTransactionWriter(this.transactionWriter());
        return gemfireCache;
    }

    void setCacheXml(Resource cacheXml) {
        this.cacheXml = cacheXml;
    }

    protected Resource cacheXml() {
        return this.cacheXml;
    }

    void setClose(boolean close) {
        this.close = close;
    }

    protected boolean close() {
        return this.close;
    }

    void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    protected boolean copyOnRead() {
        return this.copyOnRead;
    }

    void setCriticalHeapPercentage(Float criticalHeapPercentage) {
        this.criticalHeapPercentage = criticalHeapPercentage;
    }

    protected Float criticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    void setDynamicRegionSupport(CacheFactoryBean.DynamicRegionSupport dynamicRegionSupport) {
        this.dynamicRegionSupport = dynamicRegionSupport;
    }

    protected CacheFactoryBean.DynamicRegionSupport dynamicRegionSupport() {
        return this.dynamicRegionSupport;
    }

    void setEvictionHeapPercentage(Float evictionHeapPercentage) {
        this.evictionHeapPercentage = evictionHeapPercentage;
    }

    protected Float evictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    void setGatewayConflictResolver(GatewayConflictResolver gatewayConflictResolver) {
        this.gatewayConflictResolver = gatewayConflictResolver;
    }

    protected GatewayConflictResolver gatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    void setJndiDataSources(List<CacheFactoryBean.JndiDataSource> jndiDataSources) {
        this.jndiDataSources = jndiDataSources;
    }

    protected List<CacheFactoryBean.JndiDataSource> jndiDataSources() {
        return CollectionUtils.nullSafeList(this.jndiDataSources);
    }

    void setLocators(String locators) {
        this.locators = locators;
        this.mcastPort = 0;
    }

    protected String locators() {
        return this.locators;
    }

    void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    protected String logLevel() {
        return SpringUtils.defaultIfNull(this.logLevel, DEFAULT_LOG_LEVEL);
    }

    void setMappingContext(GemfireMappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    protected GemfireMappingContext mappingContext() {
        return this.mappingContext;
    }

    void setMcastPort(Integer mcastPort) {
        this.mcastPort = mcastPort;
        this.locators = DEFAULT_LOCATORS;
    }

    protected Integer mcastPort() {
        return this.mcastPort != null ? this.mcastPort : 0;
    }

    void setName(String name) {
        this.name = name;
    }

    protected String name() {
        return StringUtils.hasText((String)this.name) ? this.name : this.toString();
    }

    void setPdxDiskStoreName(String pdxDiskStoreName) {
        this.pdxDiskStoreName = pdxDiskStoreName;
    }

    protected String pdxDiskStoreName() {
        return this.pdxDiskStoreName;
    }

    void setPdxIgnoreUnreadFields(Boolean pdxIgnoreUnreadFields) {
        this.pdxIgnoreUnreadFields = pdxIgnoreUnreadFields;
    }

    protected Boolean pdxIgnoreUnreadFields() {
        return this.pdxIgnoreUnreadFields;
    }

    void setPdxPersistent(Boolean pdxPersistent) {
        this.pdxPersistent = pdxPersistent;
    }

    protected Boolean pdxPersistent() {
        return this.pdxPersistent;
    }

    void setPdxReadSerialized(Boolean pdxReadSerialized) {
        this.pdxReadSerialized = pdxReadSerialized;
    }

    protected Boolean pdxReadSerialized() {
        return this.pdxReadSerialized;
    }

    void setPdxSerializer(PdxSerializer pdxSerializer) {
        this.pdxSerializer = pdxSerializer;
    }

    protected PdxSerializer pdxSerializer() {
        return this.pdxSerializer;
    }

    void setStartLocator(String startLocator) {
        this.startLocator = startLocator;
    }

    protected String startLocator() {
        return this.startLocator;
    }

    void setTransactionListeners(List<TransactionListener> transactionListeners) {
        this.transactionListeners = transactionListeners;
    }

    protected List<TransactionListener> transactionListeners() {
        return CollectionUtils.nullSafeList(this.transactionListeners);
    }

    void setTransactionWriter(TransactionWriter transactionWriter) {
        this.transactionWriter = transactionWriter;
    }

    protected TransactionWriter transactionWriter() {
        return this.transactionWriter;
    }

    void setUseBeanFactoryLocator(boolean useBeanFactoryLocator) {
        this.useBeanFactoryLocator = useBeanFactoryLocator;
    }

    protected boolean useBeanFactoryLocator() {
        return this.useBeanFactoryLocator;
    }

    public void add(Properties gemfireProperties) {
        this.customGemFireProperties.add(gemfireProperties);
    }

    public String toString() {
        return DEFAULT_NAME;
    }
}

