/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.UserSpecifiedRegionAttributes;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.support.RegionShortcutWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public abstract class RegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements DisposableBean,
SmartLifecycle {
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean close = true;
    private boolean destroy = false;
    private boolean running;
    private Boolean offHeap;
    private Boolean persistent;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private DataPolicy dataPolicy;
    private Object[] asyncEventQueues;
    private Object[] gatewaySenders;
    private RegionAttributes<K, V> attributes;
    private RegionShortcut shortcut;
    private Resource snapshot;
    private Scope scope;
    private String diskStoreName;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.postProcess(this.getRegion());
    }

    @Override
    protected Region<K, V> lookupFallback(GemFireCache gemfireCache, String regionName) throws Exception {
        Region region;
        Assert.isTrue((boolean)(gemfireCache instanceof Cache), (String)String.format("Unable to create Regions from '%1$s'.", gemfireCache));
        Cache cache = (Cache)gemfireCache;
        RegionFactory<K, V> regionFactory = this.createRegionFactory(cache);
        if (!ObjectUtils.isEmpty((Object[])this.asyncEventQueues)) {
            for (Object asyncEventQueue : this.asyncEventQueues) {
                regionFactory.addAsyncEventQueueId(((AsyncEventQueue)asyncEventQueue).getId());
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.gatewaySenders)) {
            for (Object gatewaySender : this.gatewaySenders) {
                regionFactory.addGatewaySenderId(((GatewaySender)gatewaySender).getId());
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.cacheListeners)) {
            for (CacheListener<K, V> listener : this.cacheListeners) {
                regionFactory.addCacheListener((CacheListener)listener);
            }
        }
        if (this.cacheLoader != null) {
            regionFactory.setCacheLoader(this.cacheLoader);
        }
        if (this.cacheWriter != null) {
            regionFactory.setCacheWriter(this.cacheWriter);
        }
        this.resolveDataPolicy(regionFactory, this.persistent, this.dataPolicy);
        if (this.isDiskStoreConfigurationAllowed()) {
            regionFactory.setDiskStoreName(this.diskStoreName);
        }
        if (this.scope != null) {
            regionFactory.setScope(this.scope);
        }
        if (this.attributes != null) {
            Assert.state((!this.attributes.isLockGrantor() || this.scope == null || this.scope.isGlobal() ? 1 : 0) != 0, (String)"Lock Grantor only applies to a 'GLOBAL' scoped Region.");
        }
        this.postProcess(regionFactory);
        Region region2 = region = this.getParent() != null ? regionFactory.createSubregion(this.getParent(), regionName) : regionFactory.create(regionName);
        if (this.log.isInfoEnabled()) {
            if (this.getParent() != null) {
                this.log.info((Object)String.format("Created new Cache sub-Region [%1$s] under parent Region [%2$s].", regionName, this.getParent().getName()));
            } else {
                this.log.info((Object)String.format("Created new Cache Region [%1$s].", regionName));
            }
        }
        if (this.snapshot != null) {
            region.loadSnapshot(this.snapshot.getInputStream());
        }
        if (this.attributes != null && this.attributes.isLockGrantor()) {
            region.becomeLockGrantor();
        }
        return region;
    }

    protected RegionFactory<K, V> createRegionFactory(Cache cache) {
        if (this.shortcut != null) {
            RegionFactory<K, V> regionFactory = this.mergeRegionAttributes(cache.createRegionFactory(this.shortcut), this.attributes);
            this.setDataPolicy(this.getDataPolicy(regionFactory));
            return regionFactory;
        }
        if (this.attributes != null) {
            return cache.createRegionFactory(this.attributes);
        }
        return cache.createRegionFactory();
    }

    DataPolicy getDataPolicy(RegionFactory regionFactory) {
        return ((RegionAttributes)this.getFieldValue(this.getFieldValue(regionFactory, "attrsFactory", AttributesFactory.class), "regionAttributes", null)).getDataPolicy();
    }

    private <T> T getFieldValue(Object source, String fieldName, Class<T> targetType) {
        Field field = ReflectionUtils.findField(source.getClass(), (String)fieldName, targetType);
        ReflectionUtils.makeAccessible((Field)field);
        return (T)ReflectionUtils.getField((Field)field, (Object)source);
    }

    protected <K, V> RegionFactory<K, V> mergeRegionAttributes(RegionFactory<K, V> regionFactory, RegionAttributes<K, V> regionAttributes) {
        if (regionAttributes != null) {
            this.validateRegionAttributes(regionAttributes);
            regionFactory.setCloningEnabled(regionAttributes.getCloningEnabled());
            regionFactory.setCompressor(regionAttributes.getCompressor());
            regionFactory.setConcurrencyChecksEnabled(regionAttributes.getConcurrencyChecksEnabled());
            regionFactory.setConcurrencyLevel(regionAttributes.getConcurrencyLevel());
            regionFactory.setCustomEntryIdleTimeout(regionAttributes.getCustomEntryIdleTimeout());
            regionFactory.setCustomEntryTimeToLive(regionAttributes.getCustomEntryTimeToLive());
            regionFactory.setDiskSynchronous(regionAttributes.isDiskSynchronous());
            regionFactory.setEnableAsyncConflation(regionAttributes.getEnableAsyncConflation());
            regionFactory.setEnableSubscriptionConflation(regionAttributes.getEnableSubscriptionConflation());
            regionFactory.setEntryIdleTimeout(regionAttributes.getEntryIdleTimeout());
            regionFactory.setEntryTimeToLive(regionAttributes.getEntryTimeToLive());
            if (this.isUserSpecifiedEvictionAttributes(regionAttributes)) {
                regionFactory.setEvictionAttributes(regionAttributes.getEvictionAttributes());
            }
            regionFactory.setIgnoreJTA(regionAttributes.getIgnoreJTA());
            regionFactory.setIndexMaintenanceSynchronous(regionAttributes.getIndexMaintenanceSynchronous());
            regionFactory.setInitialCapacity(regionAttributes.getInitialCapacity());
            regionFactory.setKeyConstraint(regionAttributes.getKeyConstraint());
            regionFactory.setLoadFactor(regionAttributes.getLoadFactor());
            regionFactory.setLockGrantor(regionAttributes.isLockGrantor());
            regionFactory.setMembershipAttributes(regionAttributes.getMembershipAttributes());
            regionFactory.setMulticastEnabled(regionAttributes.getMulticastEnabled());
            regionFactory.setOffHeap(regionAttributes.getOffHeap());
            this.mergePartitionAttributes(regionFactory, regionAttributes);
            regionFactory.setPoolName(regionAttributes.getPoolName());
            regionFactory.setRegionIdleTimeout(regionAttributes.getRegionIdleTimeout());
            regionFactory.setRegionTimeToLive(regionAttributes.getRegionTimeToLive());
            regionFactory.setStatisticsEnabled(regionAttributes.getStatisticsEnabled());
            regionFactory.setSubscriptionAttributes(regionAttributes.getSubscriptionAttributes());
            regionFactory.setValueConstraint(regionAttributes.getValueConstraint());
        }
        return regionFactory;
    }

    protected <K, V> void mergePartitionAttributes(RegionFactory<K, V> regionFactory, RegionAttributes<K, V> regionAttributes) {
        if (regionAttributes.getPartitionAttributes() != null) {
            PartitionAttributes partitionAttributes = regionAttributes.getPartitionAttributes();
            PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory(partitionAttributes);
            RegionShortcutWrapper shortcutWrapper = RegionShortcutWrapper.valueOf(this.shortcut);
            if (shortcutWrapper.isRedundant() && partitionAttributes.getRedundantCopies() == 0) {
                partitionAttributesFactory.setRedundantCopies(1);
            }
            if (shortcutWrapper.isProxy()) {
                partitionAttributesFactory.setLocalMaxMemory(0);
            }
            regionFactory.setPartitionAttributes(partitionAttributesFactory.create());
        }
    }

    void validateRegionAttributes(RegionAttributes regionAttributes) {
        AttributesFactory.validateAttributes((RegionAttributes)regionAttributes);
    }

    boolean isUserSpecifiedEvictionAttributes(RegionAttributes regionAttributes) {
        return regionAttributes instanceof UserSpecifiedRegionAttributes && ((UserSpecifiedRegionAttributes)regionAttributes).hasEvictionAttributes();
    }

    private boolean isDiskStoreConfigurationAllowed() {
        boolean allow = this.diskStoreName != null;
        return allow &= this.getDataPolicy().withPersistence() || this.getAttributes() != null && this.getAttributes().getEvictionAttributes() != null && EvictionAction.OVERFLOW_TO_DISK.equals(this.attributes.getEvictionAttributes().getAction());
    }

    protected boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    protected boolean isPersistentUnspecified() {
        return this.persistent == null;
    }

    protected boolean isNotPersistent() {
        return Boolean.FALSE.equals(this.persistent);
    }

    protected void assertDataPolicyAndPersistentAttributesAreCompatible(DataPolicy resolvedDataPolicy) {
        if (resolvedDataPolicy.withPersistence()) {
            Assert.isTrue((this.isPersistentUnspecified() || this.isPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy '%1$s' is invalid when persistent is false.", resolvedDataPolicy));
        } else {
            Assert.isTrue((this.isPersistentUnspecified() || this.isNotPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy '%1$s' is invalid when persistent is true.", resolvedDataPolicy));
        }
    }

    protected void postProcess(RegionFactory<K, V> regionFactory) {
        regionFactory.setOffHeap(Boolean.TRUE.equals(this.offHeap));
    }

    protected void postProcess(Region<K, V> region) {
    }

    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, DataPolicy dataPolicy) {
        if (dataPolicy != null) {
            this.assertDataPolicyAndPersistentAttributesAreCompatible(dataPolicy);
            regionFactory.setDataPolicy(dataPolicy);
            this.setDataPolicy(dataPolicy);
        } else {
            this.resolveDataPolicy(regionFactory, persistent, (String)null);
        }
    }

    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        if (dataPolicy != null) {
            DataPolicy resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy '%1$s' is invalid.", dataPolicy));
            this.assertDataPolicyAndPersistentAttributesAreCompatible(resolvedDataPolicy);
            regionFactory.setDataPolicy(resolvedDataPolicy);
            this.setDataPolicy(resolvedDataPolicy);
        } else {
            DataPolicy regionAttributesDataPolicy = this.getDataPolicy(this.getAttributes(), DataPolicy.DEFAULT);
            DataPolicy resolvedDataPolicy = this.isPersistent() && DataPolicy.DEFAULT.equals(regionAttributesDataPolicy) ? DataPolicy.PERSISTENT_REPLICATE : regionAttributesDataPolicy;
            this.assertDataPolicyAndPersistentAttributesAreCompatible(resolvedDataPolicy);
            regionFactory.setDataPolicy(resolvedDataPolicy);
            this.setDataPolicy(resolvedDataPolicy);
        }
    }

    private DataPolicy getDataPolicy(RegionAttributes regionAttributes, DataPolicy defaultDataPolicy) {
        return regionAttributes != null ? regionAttributes.getDataPolicy() : defaultDataPolicy;
    }

    public void destroy() throws Exception {
        Region region = this.getObject();
        if (region != null) {
            if (this.close && !region.getRegionService().isClosed()) {
                try {
                    region.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.destroy) {
                region.destroyRegion();
            }
        }
    }

    public void setAsyncEventQueues(Object[] asyncEventQueues) {
        this.asyncEventQueues = asyncEventQueues;
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }

    public RegionAttributes getAttributes() {
        Region region = this.getRegion();
        return region != null ? region.getAttributes() : this.attributes;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    @Deprecated
    public void setDataPolicy(String dataPolicyName) {
        this.setDataPolicy(new DataPolicyConverter().convert(dataPolicyName));
    }

    public DataPolicy getDataPolicy() {
        Assert.state((this.dataPolicy != null ? 1 : 0) != 0, (String)"The Data Policy has not been properly resolved yet!");
        return this.dataPolicy;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    public void setGatewaySenders(Object[] gatewaySenders) {
        this.gatewaySenders = gatewaySenders;
    }

    public void setOffHeap(Boolean offHeap) {
        this.offHeap = offHeap;
    }

    public Boolean getOffHeap() {
        return this.offHeap;
    }

    public boolean isOffHeap() {
        return Boolean.TRUE.equals(this.getOffHeap());
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setShortcut(RegionShortcut shortcut) {
        this.shortcut = shortcut;
    }

    protected final RegionShortcut getShortcut() {
        return this.shortcut;
    }

    public void setSnapshot(Resource snapshot) {
        this.snapshot = snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start() {
        if (!ObjectUtils.isEmpty((Object[])this.gatewaySenders)) {
            Object[] objectArray = this.gatewaySenders;
            // MONITORENTER : this.gatewaySenders
            for (Object obj : this.gatewaySenders) {
                GatewaySender gatewaySender = (GatewaySender)obj;
                if (gatewaySender.isManualStart() || gatewaySender.isRunning()) continue;
                gatewaySender.start();
            }
            // MONITOREXIT : objectArray
        }
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop() {
        if (!ObjectUtils.isEmpty((Object[])this.gatewaySenders)) {
            Object[] objectArray = this.gatewaySenders;
            // MONITORENTER : this.gatewaySenders
            for (Object gatewaySender : this.gatewaySenders) {
                ((GatewaySender)gatewaySender).stop();
            }
            // MONITOREXIT : objectArray
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

