/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.Declarable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.gemfire.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.support.SpringContextBootstrappingInitializer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class LazyWiringDeclarableSupport
implements ApplicationListener<ContextRefreshedEvent>,
Declarable,
DisposableBean {
    protected static final String BEAN_NAME_PARAMETER = "bean-name";
    private final AtomicReference<Properties> parametersReference = new AtomicReference();
    volatile boolean initialized = false;
    private BeanFactoryReference beanFactoryReference = null;
    private String factoryKey = null;

    public LazyWiringDeclarableSupport() {
        SpringContextBootstrappingInitializer.register(this);
    }

    public final void setFactoryKey(String factoryKey) {
        this.factoryKey = factoryKey;
    }

    protected String getFactoryKey() {
        return this.factoryKey;
    }

    protected void assertInitialized() {
        Assert.state((boolean)this.isInitialized(), (String)String.format("This Declarable object (%1$s) has not been properly configured and initialized", this.getClass().getName()));
    }

    protected void assertUninitialized() {
        Assert.state((!this.isInitialized() ? 1 : 0) != 0, (String)String.format("This Declarable object (%1$s) has already been configured and initialized", this.getClass().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doInit(BeanFactory beanFactory, Properties parameters) {
        LazyWiringDeclarableSupport lazyWiringDeclarableSupport = this;
        synchronized (lazyWiringDeclarableSupport) {
            if (this.isNotInitialized()) {
                BeanConfigurerSupport beanConfigurer = new BeanConfigurerSupport();
                beanConfigurer.setBeanFactory(beanFactory);
                final String templateBeanName = parameters.getProperty(BEAN_NAME_PARAMETER);
                if (StringUtils.hasText((String)templateBeanName)) {
                    if (beanFactory.containsBean(templateBeanName)) {
                        beanConfigurer.setBeanWiringInfoResolver(new BeanWiringInfoResolver(){

                            public BeanWiringInfo resolveWiringInfo(Object beanInstance) {
                                return new BeanWiringInfo(templateBeanName);
                            }
                        });
                    } else {
                        throw new IllegalArgumentException(String.format("No bean with name '%1$s' was found in the Spring context '%2$s'.", templateBeanName, beanFactory));
                    }
                }
                beanConfigurer.afterPropertiesSet();
                beanConfigurer.configureBean((Object)this);
                beanConfigurer.destroy();
                this.initialized = true;
            }
        }
        this.doPostInit(parameters);
    }

    protected void doPostInit(Properties parameters) {
    }

    public final void init(Properties parameters) {
        this.parametersReference.set(parameters);
        try {
            this.doInit(this.locateBeanFactory(this.getFactoryKey()), this.nullSafeGetParameters());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected boolean isNotInitialized() {
        return !this.isInitialized();
    }

    protected BeanFactory locateBeanFactory(String factoryKey) {
        if (this.beanFactoryReference == null) {
            this.beanFactoryReference = new GemfireBeanFactoryLocator().useBeanFactory(factoryKey);
        }
        return this.beanFactoryReference.getFactory();
    }

    protected Properties nullSafeGetParameters() {
        Properties parameters = this.parametersReference.get();
        return parameters != null ? parameters : new Properties();
    }

    public final void onApplicationEvent(ContextRefreshedEvent event) {
        Assert.isTrue((boolean)(event.getApplicationContext() instanceof ConfigurableApplicationContext), (String)String.format("The Spring ApplicationContext (%1$s) must be an instance of ConfigurableApplicationContext", ObjectUtils.nullSafeClassName((Object)event.getApplicationContext())));
        this.doInit((BeanFactory)((ConfigurableApplicationContext)event.getApplicationContext()).getBeanFactory(), this.nullSafeGetParameters());
    }

    public void destroy() throws Exception {
        SpringContextBootstrappingInitializer.unregister(this);
        this.beanFactoryReference.release();
        this.parametersReference.set(null);
        this.initialized = false;
    }
}

