/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.GemFireCheckedException;
import org.apache.geode.GemFireException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.TransactionWriter;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.datasource.ConfigProperty;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.pdx.PdxSerializer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Phased;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.gemfire.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.GemfireSystemException;
import org.springframework.data.gemfire.JndiDataSourceType;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class CacheFactoryBean
implements BeanClassLoaderAware,
BeanFactoryAware,
BeanNameAware,
FactoryBean<Cache>,
Phased,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    private boolean close = true;
    private boolean useBeanFactoryLocator = false;
    private int phase = -1;
    protected final Log log = LogFactory.getLog(this.getClass());
    private BeanFactory beanFactory;
    private Boolean copyOnRead;
    private Boolean enableAutoReconnect;
    private Boolean pdxIgnoreUnreadFields;
    private Boolean pdxPersistent;
    private Boolean pdxReadSerialized;
    private Boolean useClusterConfiguration;
    private Cache cache;
    private ClassLoader beanClassLoader;
    private DynamicRegionSupport dynamicRegionSupport;
    private Float criticalHeapPercentage;
    private Float evictionHeapPercentage;
    protected GemfireBeanFactoryLocator beanFactoryLocator;
    private Integer lockLease;
    private Integer lockTimeout;
    private Integer messageSyncInterval;
    private Integer searchTimeout;
    private List<JndiDataSource> jndiDataSources;
    private List<TransactionListener> transactionListeners;
    private Object gatewayConflictResolver;
    private Object pdxSerializer;
    private Properties properties;
    private Resource cacheXml;
    private String beanName;
    private String cacheResolutionMessagePrefix;
    private String pdxDiskStoreName;
    private TransactionWriter transactionWriter;

    public void afterPropertiesSet() throws Exception {
        this.postProcessBeforeCacheInitialization(this.resolveProperties());
    }

    protected void postProcessBeforeCacheInitialization(Properties gemfireProperties) {
        gemfireProperties.setProperty("disable-auto-reconnect", String.valueOf(!Boolean.TRUE.equals(this.getEnableAutoReconnect())));
        gemfireProperties.setProperty("use-cluster-configuration", String.valueOf(Boolean.TRUE.equals(this.getUseClusterConfiguration())));
    }

    protected void setCache(Cache cache) {
        this.cache = cache;
    }

    protected <T extends GemFireCache> T getCache() {
        return (T)this.cache;
    }

    public Cache getObject() throws Exception {
        return this.cache != null ? this.cache : this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Cache init() throws Exception {
        this.initBeanFactoryLocator();
        ClassLoader currentThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.beanClassLoader);
            this.cache = this.postProcess(this.resolveCache());
            DistributedSystem system = this.cache.getDistributedSystem();
            DistributedMember member = system.getDistributedMember();
            this.log.info((Object)String.format("Connected to Distributed System [%1$s] as Member [%2$s]".concat("in Group(s) [%3$s] with Role(s) [%4$s] on Host [%5$s] having PID [%6$d]."), system.getName(), member.getId(), member.getGroups(), member.getRoles(), member.getHost(), member.getProcessId()));
            this.log.info((Object)String.format("%1$s GemFire v.%2$s Cache [%3$s].", this.cacheResolutionMessagePrefix, CacheFactory.getVersion(), this.cache.getName()));
            Cache cache = this.cache;
            return cache;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentThreadContextClassLoader);
        }
    }

    private void initBeanFactoryLocator() {
        if (this.useBeanFactoryLocator && this.beanFactoryLocator == null) {
            this.beanFactoryLocator = new GemfireBeanFactoryLocator();
            this.beanFactoryLocator.setBeanFactory(this.beanFactory);
            this.beanFactoryLocator.setBeanName(this.beanName);
            this.beanFactoryLocator.afterPropertiesSet();
        }
    }

    private void initDynamicRegionFactory() {
        if (this.dynamicRegionSupport != null) {
            this.dynamicRegionSupport.initializeDynamicRegionFactory();
        }
    }

    protected Cache resolveCache() {
        try {
            this.cacheResolutionMessagePrefix = "Found existing";
            return (Cache)this.fetchCache();
        }
        catch (CacheClosedException ex) {
            this.cacheResolutionMessagePrefix = "Created new";
            this.initDynamicRegionFactory();
            return (Cache)this.createCache(this.prepareFactory(this.createFactory(this.resolveProperties())));
        }
    }

    protected <T extends GemFireCache> T fetchCache() {
        return (T)(this.cache != null ? this.cache : CacheFactory.getAnyInstance());
    }

    protected Properties resolveProperties() {
        return this.properties != null ? this.properties : (this.properties = new Properties());
    }

    protected Object createFactory(Properties gemfireProperties) {
        return new CacheFactory(gemfireProperties);
    }

    protected Object prepareFactory(Object factory) {
        return this.initializePdx((CacheFactory)factory);
    }

    CacheFactory initializePdx(CacheFactory cacheFactory) {
        if (this.isPdxOptionsSpecified()) {
            if (this.pdxSerializer != null) {
                Assert.isInstanceOf(PdxSerializer.class, (Object)this.pdxSerializer, (String)String.format("[%1$s] of type [%2$s] is not a PdxSerializer", this.pdxSerializer, ObjectUtils.nullSafeClassName((Object)this.pdxSerializer)));
                cacheFactory.setPdxSerializer((PdxSerializer)this.pdxSerializer);
            }
            if (this.pdxDiskStoreName != null) {
                cacheFactory.setPdxDiskStore(this.pdxDiskStoreName);
            }
            if (this.pdxIgnoreUnreadFields != null) {
                cacheFactory.setPdxIgnoreUnreadFields(this.pdxIgnoreUnreadFields.booleanValue());
            }
            if (this.pdxPersistent != null) {
                cacheFactory.setPdxPersistent(this.pdxPersistent.booleanValue());
            }
            if (this.pdxReadSerialized != null) {
                cacheFactory.setPdxReadSerialized(this.pdxReadSerialized.booleanValue());
            }
        }
        return cacheFactory;
    }

    protected boolean isPdxOptionsSpecified() {
        return this.pdxSerializer != null || this.pdxReadSerialized != null || this.pdxPersistent != null || this.pdxIgnoreUnreadFields != null || this.pdxDiskStoreName != null;
    }

    protected <T extends GemFireCache> T createCache(Object factory) {
        return (T)(this.cache != null ? this.cache : ((CacheFactory)factory).create());
    }

    protected <T extends GemFireCache> T postProcess(T cache) throws IOException {
        Resource localCacheXml = this.getCacheXml();
        if (localCacheXml != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("initializing Cache with '%1$s'", this.cacheXml));
            }
            cache.loadCacheXml(localCacheXml.getInputStream());
        }
        if (this.copyOnRead != null) {
            cache.setCopyOnRead(this.copyOnRead.booleanValue());
        }
        if (this.gatewayConflictResolver != null) {
            ((Cache)cache).setGatewayConflictResolver((GatewayConflictResolver)this.gatewayConflictResolver);
        }
        if (this.lockLease != null) {
            ((Cache)cache).setLockLease(this.lockLease.intValue());
        }
        if (this.lockTimeout != null) {
            ((Cache)cache).setLockTimeout(this.lockTimeout.intValue());
        }
        if (this.messageSyncInterval != null) {
            ((Cache)cache).setMessageSyncInterval(this.messageSyncInterval.intValue());
        }
        if (this.searchTimeout != null) {
            ((Cache)cache).setSearchTimeout(this.searchTimeout.intValue());
        }
        this.setHeapPercentages(cache);
        this.registerTransactionListeners(cache);
        this.registerTransactionWriter(cache);
        this.registerJndiDataSources();
        return cache;
    }

    private void setHeapPercentages(GemFireCache cache) {
        if (this.criticalHeapPercentage != null) {
            Assert.isTrue(((double)this.criticalHeapPercentage.floatValue() > 0.0 && (double)this.criticalHeapPercentage.floatValue() <= 100.0 ? 1 : 0) != 0, (String)String.format("'criticalHeapPercentage' (%1$s) is invalid; must be > 0.0 and <= 100.0", this.criticalHeapPercentage));
            cache.getResourceManager().setCriticalHeapPercentage(this.criticalHeapPercentage.floatValue());
        }
        if (this.evictionHeapPercentage != null) {
            Assert.isTrue(((double)this.evictionHeapPercentage.floatValue() > 0.0 && (double)this.evictionHeapPercentage.floatValue() <= 100.0 ? 1 : 0) != 0, (String)String.format("'evictionHeapPercentage' (%1$s) is invalid; must be > 0.0 and <= 100.0", this.evictionHeapPercentage));
            cache.getResourceManager().setEvictionHeapPercentage(this.evictionHeapPercentage.floatValue());
        }
    }

    private void registerTransactionListeners(GemFireCache cache) {
        for (TransactionListener transactionListener : CollectionUtils.nullSafeCollection(this.transactionListeners)) {
            cache.getCacheTransactionManager().addListener(transactionListener);
        }
    }

    private void registerTransactionWriter(GemFireCache cache) {
        if (this.transactionWriter != null) {
            cache.getCacheTransactionManager().setWriter(this.transactionWriter);
        }
    }

    private void registerJndiDataSources() {
        for (JndiDataSource jndiDataSource : CollectionUtils.nullSafeCollection(this.jndiDataSources)) {
            String typeAttributeValue = jndiDataSource.getAttributes().get("type");
            JndiDataSourceType jndiDataSourceType = JndiDataSourceType.valueOfIgnoreCase(typeAttributeValue);
            Assert.notNull((Object)((Object)jndiDataSourceType), (String)String.format("'jndi-binding' 'type' [%1$s] is invalid; 'type' must be one of %2$s", typeAttributeValue, Arrays.toString((Object[])JndiDataSourceType.values())));
            jndiDataSource.getAttributes().put("type", jndiDataSourceType.getName());
            JNDIInvoker.mapDatasource(jndiDataSource.getAttributes(), jndiDataSource.getProps());
        }
    }

    public void destroy() throws Exception {
        if (this.close) {
            Cache localCache = (Cache)this.fetchCache();
            if (localCache != null && !localCache.isClosed()) {
                this.close((GemFireCache)localCache);
            }
            this.cache = null;
            if (this.beanFactoryLocator != null) {
                this.beanFactoryLocator.destroy();
                this.beanFactoryLocator = null;
            }
        }
    }

    protected void close(GemFireCache cache) {
        cache.close();
    }

    public Class<? extends GemFireCache> getObjectType() {
        return this.cache != null ? this.cache.getClass() : Cache.class;
    }

    protected void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isSingleton() {
        return true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        DataAccessException wrapped;
        if (e instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)e);
        }
        if (e instanceof IllegalArgumentException && !((wrapped = GemfireCacheUtils.convertQueryExceptions(e)) instanceof GemfireSystemException)) {
            return wrapped;
        }
        if (e.getCause() instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)e.getCause());
        }
        if (e.getCause() instanceof GemFireCheckedException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireCheckedException)e.getCause());
        }
        return null;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public GemfireBeanFactoryLocator getBeanFactoryLocator() {
        return this.beanFactoryLocator;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setCacheXml(Resource cacheXml) {
        this.cacheXml = cacheXml;
    }

    public Resource getCacheXml() {
        return this.cacheXml;
    }

    private File getCacheXmlFile() {
        try {
            return this.getCacheXml().getFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Resource (%1$s) is not resolvable as a file", e));
        }
    }

    private boolean isCacheXmlAvailable() {
        try {
            Resource localCacheXml = this.getCacheXml();
            return localCacheXml != null && localCacheXml.getFile().isFile();
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public Boolean getClose() {
        return this.close;
    }

    public void setCopyOnRead(Boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    public Boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    public void setCriticalHeapPercentage(Float criticalHeapPercentage) {
        this.criticalHeapPercentage = criticalHeapPercentage;
    }

    public Float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    public void setDynamicRegionSupport(DynamicRegionSupport dynamicRegionSupport) {
        this.dynamicRegionSupport = dynamicRegionSupport;
    }

    public DynamicRegionSupport getDynamicRegionSupport() {
        return this.dynamicRegionSupport;
    }

    public void setEnableAutoReconnect(Boolean enableAutoReconnect) {
        this.enableAutoReconnect = enableAutoReconnect;
    }

    public Boolean getEnableAutoReconnect() {
        return this.enableAutoReconnect;
    }

    public void setEvictionHeapPercentage(Float evictionHeapPercentage) {
        this.evictionHeapPercentage = evictionHeapPercentage;
    }

    public Float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    public void setGatewayConflictResolver(Object gatewayConflictResolver) {
        this.gatewayConflictResolver = gatewayConflictResolver;
    }

    public Object getGatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    public void setJndiDataSources(List<JndiDataSource> jndiDataSources) {
        this.jndiDataSources = jndiDataSources;
    }

    public List<JndiDataSource> getJndiDataSources() {
        return this.jndiDataSources;
    }

    public void setLockLease(Integer lockLease) {
        this.lockLease = lockLease;
    }

    public Integer getLockLease() {
        return this.lockLease;
    }

    public void setLockTimeout(Integer lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public Integer getLockTimeout() {
        return this.lockTimeout;
    }

    public void setMessageSyncInterval(Integer messageSyncInterval) {
        this.messageSyncInterval = messageSyncInterval;
    }

    public Integer getMessageSyncInterval() {
        return this.messageSyncInterval;
    }

    public void setPdxDiskStoreName(String pdxDiskStoreName) {
        this.pdxDiskStoreName = pdxDiskStoreName;
    }

    public String getPdxDiskStoreName() {
        return this.pdxDiskStoreName;
    }

    public void setPdxIgnoreUnreadFields(Boolean pdxIgnoreUnreadFields) {
        this.pdxIgnoreUnreadFields = pdxIgnoreUnreadFields;
    }

    public Boolean getPdxIgnoreUnreadFields() {
        return this.pdxIgnoreUnreadFields;
    }

    public void setPdxPersistent(Boolean pdxPersistent) {
        this.pdxPersistent = pdxPersistent;
    }

    public Boolean getPdxPersistent() {
        return this.pdxPersistent;
    }

    public void setPdxReadSerialized(Boolean pdxReadSerialized) {
        this.pdxReadSerialized = pdxReadSerialized;
    }

    public Boolean getPdxReadSerialized() {
        return this.pdxReadSerialized;
    }

    public void setPdxSerializer(Object serializer) {
        this.pdxSerializer = serializer;
    }

    public Object getPdxSerializer() {
        return this.pdxSerializer;
    }

    public void setSearchTimeout(Integer searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    public Integer getSearchTimeout() {
        return this.searchTimeout;
    }

    public void setTransactionListeners(List<TransactionListener> transactionListeners) {
        this.transactionListeners = transactionListeners;
    }

    public List<TransactionListener> getTransactionListeners() {
        return this.transactionListeners;
    }

    public void setTransactionWriter(TransactionWriter transactionWriter) {
        this.transactionWriter = transactionWriter;
    }

    public TransactionWriter getTransactionWriter() {
        return this.transactionWriter;
    }

    public void setUseBeanFactoryLocator(boolean usage) {
        this.useBeanFactoryLocator = usage;
    }

    public boolean isUseBeanFactoryLocator() {
        return this.useBeanFactoryLocator;
    }

    public void setUseClusterConfiguration(Boolean useSharedConfiguration) {
        this.useClusterConfiguration = useSharedConfiguration;
    }

    public Boolean getUseClusterConfiguration() {
        return this.useClusterConfiguration;
    }

    public static class JndiDataSource {
        private List<ConfigProperty> props;
        private Map<String, String> attributes;

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public List<ConfigProperty> getProps() {
            return this.props;
        }

        public void setProps(List<ConfigProperty> props) {
            this.props = props;
        }
    }

    public static class DynamicRegionSupport {
        private Boolean persistent = Boolean.TRUE;
        private Boolean registerInterest = Boolean.TRUE;
        private String diskDirectory;
        private String poolName;

        public void setDiskDir(String diskDirectory) {
            this.diskDirectory = diskDirectory;
        }

        public String getDiskDir() {
            return this.diskDirectory;
        }

        public void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        public Boolean getPersistent() {
            return this.persistent;
        }

        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void setRegisterInterest(Boolean registerInterest) {
            this.registerInterest = registerInterest;
        }

        public Boolean getRegisterInterest() {
            return this.registerInterest;
        }

        public void initializeDynamicRegionFactory() {
            File localDiskDirectory = this.diskDirectory != null ? new File(this.diskDirectory) : null;
            DynamicRegionFactory.Config config = new DynamicRegionFactory.Config(localDiskDirectory, this.poolName, this.persistent.booleanValue(), this.registerInterest.booleanValue());
            DynamicRegionFactory.get().open(config);
        }
    }
}

