/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.MethodInvokingBean;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.config.support.ClientRegionPoolBeanFactoryPostProcessor;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class PoolParser
extends AbstractSingleBeanDefinitionParser {
    static final AtomicBoolean INFRASTRUCTURE_COMPONENTS_REGISTERED = new AtomicBoolean(false);
    protected static final int DEFAULT_LOCATOR_PORT = 10334;
    protected static final int DEFAULT_SERVER_PORT = 40404;
    protected static final String DEFAULT_HOST = "localhost";
    protected static final String HOST_ATTRIBUTE_NAME = "host";
    protected static final String LOCATOR_ELEMENT_NAME = "locator";
    protected static final String LOCATORS_ATTRIBUTE_NAME = "locators";
    protected static final String PORT_ATTRIBUTE_NAME = "port";
    protected static final String SERVER_ELEMENT_NAME = "server";
    protected static final String SERVERS_ATTRIBUTE_NAME = "servers";

    PoolParser() {
    }

    static void registerInfrastructureComponents(ParserContext parserContext) {
        if (INFRASTRUCTURE_COMPONENTS_REGISTERED.compareAndSet(false, true)) {
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ClientRegionPoolBeanFactoryPostProcessor.class).setRole(2).getBeanDefinition();
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)parserContext.getRegistry());
        }
    }

    protected Class<?> getBeanClass(Element element) {
        return PoolFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        PoolParser.registerInfrastructureComponents(parserContext);
        ParsingUtils.setPropertyValue(element, builder, "free-connection-timeout");
        ParsingUtils.setPropertyValue(element, builder, "idle-timeout");
        ParsingUtils.setPropertyValue(element, builder, "keep-alive");
        ParsingUtils.setPropertyValue(element, builder, "load-conditioning-interval");
        ParsingUtils.setPropertyValue(element, builder, "max-connections");
        ParsingUtils.setPropertyValue(element, builder, "min-connections");
        ParsingUtils.setPropertyValue(element, builder, "multi-user-authentication");
        ParsingUtils.setPropertyValue(element, builder, "ping-interval");
        ParsingUtils.setPropertyValue(element, builder, "pr-single-hop-enabled");
        ParsingUtils.setPropertyValue(element, builder, "read-timeout");
        ParsingUtils.setPropertyValue(element, builder, "retry-attempts");
        ParsingUtils.setPropertyValue(element, builder, "server-group");
        ParsingUtils.setPropertyValue(element, builder, "socket-buffer-size");
        ParsingUtils.setPropertyValue(element, builder, "statistic-interval");
        ParsingUtils.setPropertyValue(element, builder, "subscription-ack-interval");
        ParsingUtils.setPropertyValue(element, builder, "subscription-enabled");
        ParsingUtils.setPropertyValue(element, builder, "subscription-message-tracking-timeout");
        ParsingUtils.setPropertyValue(element, builder, "subscription-redundancy");
        ParsingUtils.setPropertyValue(element, builder, "thread-local-connections");
        List childElements = DomUtils.getChildElements((Element)element);
        ManagedList locators = new ManagedList(childElements.size());
        ManagedList servers = new ManagedList(childElements.size());
        for (Element childElement : childElements) {
            String childElementName = childElement.getLocalName();
            if (LOCATOR_ELEMENT_NAME.equals(childElementName)) {
                locators.add((Object)this.parseLocator(childElement));
            }
            if (!SERVER_ELEMENT_NAME.equals(childElementName)) continue;
            servers.add((Object)this.parseServer(childElement));
        }
        boolean locatorsSet = this.parseLocators(element, this.getRegistry(parserContext));
        boolean serversSet = this.parseServers(element, this.getRegistry(parserContext));
        if (childElements.isEmpty() && !locatorsSet && !serversSet) {
            servers.add((Object)this.buildConnection(DEFAULT_HOST, String.valueOf(40404), true));
        }
        if (!locators.isEmpty()) {
            builder.addPropertyValue(LOCATORS_ATTRIBUTE_NAME, (Object)locators);
        }
        if (!servers.isEmpty()) {
            builder.addPropertyValue(SERVERS_ATTRIBUTE_NAME, (Object)servers);
        }
    }

    BeanDefinitionRegistry getRegistry(ParserContext parserContext) {
        return parserContext.getRegistry();
    }

    BeanDefinition buildConnection(String host, String port, boolean server) {
        BeanDefinitionBuilder connectionEndpointBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConnectionEndpoint.class);
        connectionEndpointBuilder.addConstructorArgValue((Object)this.defaultHost(host));
        connectionEndpointBuilder.addConstructorArgValue((Object)this.defaultPort(port, server));
        return connectionEndpointBuilder.getBeanDefinition();
    }

    BeanDefinition buildConnections(String expression, boolean server) {
        BeanDefinitionBuilder connectionEndpointListBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConnectionEndpointList.class);
        connectionEndpointListBuilder.setFactoryMethod("parse");
        connectionEndpointListBuilder.addConstructorArgValue((Object)this.defaultPort(null, server));
        connectionEndpointListBuilder.addConstructorArgValue((Object)expression);
        return connectionEndpointListBuilder.getBeanDefinition();
    }

    String defaultHost(String host) {
        return StringUtils.hasText((String)host) ? host : DEFAULT_HOST;
    }

    String defaultPort(String port, boolean server) {
        return StringUtils.hasText((String)port) ? port : (server ? String.valueOf(40404) : String.valueOf(10334));
    }

    BeanDefinition parseLocator(Element element) {
        return this.buildConnection(element.getAttribute(HOST_ATTRIBUTE_NAME), element.getAttribute(PORT_ATTRIBUTE_NAME), false);
    }

    boolean parseLocators(Element element, BeanDefinitionRegistry registry) {
        String locatorsAttributeValue = element.getAttribute(LOCATORS_ATTRIBUTE_NAME);
        if (StringUtils.hasText((String)locatorsAttributeValue)) {
            BeanDefinitionBuilder addLocatorsMethodInvokingBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingBean.class);
            addLocatorsMethodInvokingBeanBuilder.addPropertyReference("targetObject", this.resolveDereferencedId(element));
            addLocatorsMethodInvokingBeanBuilder.addPropertyValue("targetMethod", (Object)"addLocators");
            addLocatorsMethodInvokingBeanBuilder.addPropertyValue("arguments", (Object)this.buildConnections(locatorsAttributeValue, false));
            AbstractBeanDefinition addLocatorsMethodInvokingBean = addLocatorsMethodInvokingBeanBuilder.getBeanDefinition();
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)addLocatorsMethodInvokingBean, (BeanDefinitionRegistry)registry);
            return true;
        }
        return false;
    }

    BeanDefinition parseServer(Element element) {
        return this.buildConnection(element.getAttribute(HOST_ATTRIBUTE_NAME), element.getAttribute(PORT_ATTRIBUTE_NAME), true);
    }

    boolean parseServers(Element element, BeanDefinitionRegistry registry) {
        String serversAttributeValue = element.getAttribute(SERVERS_ATTRIBUTE_NAME);
        if (StringUtils.hasText((String)serversAttributeValue)) {
            BeanDefinitionBuilder addServersMethodInvokingBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingBean.class);
            addServersMethodInvokingBeanBuilder.addPropertyReference("targetObject", this.resolveDereferencedId(element));
            addServersMethodInvokingBeanBuilder.addPropertyValue("targetMethod", (Object)"addServers");
            addServersMethodInvokingBeanBuilder.addPropertyValue("arguments", (Object)this.buildConnections(serversAttributeValue, true));
            AbstractBeanDefinition addServersMethodInvokingBean = addServersMethodInvokingBeanBuilder.getBeanDefinition();
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)addServersMethodInvokingBean, (BeanDefinitionRegistry)registry);
            return true;
        }
        return false;
    }

    String resolveId(Element element) {
        String id = element.getAttribute("id");
        return StringUtils.hasText((String)id) ? id : "gemfirePool";
    }

    String resolveDereferencedId(Element element) {
        return SpringUtils.dereferenceBean(this.resolveId(element));
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)id)) {
            id = "gemfirePool";
            parserContext.getRegistry().registerAlias("gemfirePool", "gemfire-pool");
        }
        return id;
    }
}

