/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.repository.Query;
import org.springframework.data.gemfire.repository.query.annotation.Hint;
import org.springframework.data.gemfire.repository.query.annotation.Import;
import org.springframework.data.gemfire.repository.query.annotation.Limit;
import org.springframework.data.gemfire.repository.query.annotation.Trace;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GemfireQueryMethod
extends QueryMethod {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Method method;
    private final GemfirePersistentEntity<?> entity;

    public GemfireQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> context) {
        super(method, metadata, factory);
        Assert.notNull(context);
        this.assertNonPagingQueryMethod(method);
        this.method = method;
        this.entity = (GemfirePersistentEntity)context.getPersistentEntity(this.getDomainClass());
    }

    private void assertNonPagingQueryMethod(Method method) {
        for (Class<?> type : method.getParameterTypes()) {
            if (!Pageable.class.isAssignableFrom(type)) continue;
            throw new IllegalStateException(String.format("Pagination is not supported by GemFire Repositories! Offending method: %1$s", method.toString()));
        }
    }

    public GemfirePersistentEntity<?> getPersistentEntity() {
        return this.entity;
    }

    public boolean hasAnnotatedQuery() {
        return StringUtils.hasText((String)this.getAnnotatedQuery());
    }

    String getAnnotatedQuery() {
        Query query = this.method.getAnnotation(Query.class);
        String queryString = query != null ? (String)AnnotationUtils.getValue((Annotation)query) : null;
        return StringUtils.hasText((String)queryString) ? queryString : null;
    }

    public boolean hasHint() {
        return this.method.isAnnotationPresent(Hint.class);
    }

    public String[] getHints() {
        Hint hint = this.method.getAnnotation(Hint.class);
        return hint != null ? hint.value() : EMPTY_STRING_ARRAY;
    }

    public boolean hasImport() {
        return this.method.isAnnotationPresent(Import.class);
    }

    public String getImport() {
        Import importStatement = this.method.getAnnotation(Import.class);
        return importStatement != null ? importStatement.value() : null;
    }

    public boolean hasLimit() {
        return this.method.isAnnotationPresent(Limit.class);
    }

    public int getLimit() {
        Limit limit = this.method.getAnnotation(Limit.class);
        return limit != null ? limit.value() : Integer.MAX_VALUE;
    }

    public boolean hasTrace() {
        return this.method.isAnnotationPresent(Trace.class);
    }
}

