/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import com.gemstone.gemfire.cache.execute.ResultSender;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class BatchingResultSender {
    private final int batchSize;
    private ResultSender<Object> resultSender;

    public BatchingResultSender(int batchSize, ResultSender<Object> resultSender) {
        Assert.notNull(resultSender, (String)"resultSender cannot be null");
        Assert.isTrue((batchSize >= 0 ? 1 : 0) != 0, (String)"batchSize must be >= 0");
        this.batchSize = batchSize;
        this.resultSender = resultSender;
    }

    public void sendResults(Iterable<?> result) {
        if (this.batchSize == 0) {
            this.resultSender.lastResult(result);
            return;
        }
        ArrayList chunk = new ArrayList(this.batchSize);
        Iterator<?> it = result.iterator();
        while (it.hasNext()) {
            if (chunk.size() < this.batchSize) {
                chunk.add(it.next());
            }
            if (chunk.size() != this.batchSize && it.hasNext()) continue;
            if (it.hasNext()) {
                this.resultSender.sendResult(chunk);
            } else {
                this.resultSender.lastResult(chunk);
            }
            chunk.clear();
        }
    }

    public void sendArrayResults(Object result) {
        if (this.batchSize == 0) {
            this.resultSender.lastResult(result);
            return;
        }
        Assert.isTrue((boolean)ObjectUtils.isArray((Object)result));
        int length = Array.getLength(result);
        for (int from = 0; from < length; from += this.batchSize) {
            int to = Math.min(length, from + this.batchSize);
            Object chunk = this.copyOfRange(result, from, to);
            if (to == length - 1) {
                this.resultSender.lastResult(chunk);
                continue;
            }
            this.resultSender.sendResult(chunk);
        }
    }

    private Object copyOfRange(Object result, int from, int to) {
        Class<?> arrayClass = result.getClass();
        int size = to - from;
        if (int[].class.isAssignableFrom(arrayClass)) {
            int[] array = new int[size];
            for (int i = 0; i < size; ++i) {
                array[i] = Array.getInt(result, from + i);
            }
            return array;
        }
        if (float[].class.isAssignableFrom(arrayClass)) {
            float[] array = new float[size];
            for (int i = 0; i < size; ++i) {
                array[i] = Array.getFloat(result, from + i);
            }
            return array;
        }
        if (double[].class.isAssignableFrom(arrayClass)) {
            double[] array = new double[size];
            for (int i = 0; i < size; ++i) {
                array[i] = Array.getDouble(result, from + i);
            }
            return array;
        }
        if (boolean[].class.isAssignableFrom(arrayClass)) {
            boolean[] array = new boolean[size];
            for (int i = 0; i < size; ++i) {
                array[i] = Array.getBoolean(result, from + i);
            }
            return array;
        }
        if (byte[].class.isAssignableFrom(arrayClass)) {
            byte[] array = new byte[size];
            for (int i = 0; i < size; ++i) {
                array[i] = Array.getByte(result, from + i);
            }
            return array;
        }
        if (short[].class.isAssignableFrom(arrayClass)) {
            short[] array = new short[size];
            for (int i = 0; i < size; ++i) {
                array[i] = Array.getShort(result, from + i);
            }
            return array;
        }
        if (long[].class.isAssignableFrom(arrayClass)) {
            long[] array = new long[size];
            for (int i = 0; i < size; ++i) {
                array[i] = Array.getLong(result, from + i);
            }
            return array;
        }
        if (char[].class.isAssignableFrom(arrayClass)) {
            char[] array = new char[size];
            for (int i = 0; i < size; ++i) {
                array[i] = Array.getChar(result, from + i);
            }
            return array;
        }
        return Arrays.copyOfRange((Object[])result, from, to);
    }
}

