/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class GemfireBeanFactoryLocator
implements BeanFactoryLocator,
BeanFactoryAware,
BeanNameAware,
DisposableBean,
InitializingBean {
    private static final Log log = LogFactory.getLog(GemfireBeanFactoryLocator.class);
    private static final ConcurrentMap<String, BeanFactory> beanFactories = new ConcurrentHashMap<String, BeanFactory>();
    private static volatile boolean canUseDefaultBeanFactory = true;
    private static volatile BeanFactory defaultFactory = null;
    private BeanFactory beanFactory;
    private String[] names;
    private String factoryName = GemfireBeanFactoryLocator.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        Class<GemfireBeanFactoryLocator> clazz = GemfireBeanFactoryLocator.class;
        synchronized (GemfireBeanFactoryLocator.class) {
            canUseDefaultBeanFactory = beanFactories.isEmpty();
            if (canUseDefaultBeanFactory) {
                if (defaultFactory == null) {
                    defaultFactory = this.beanFactory;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("default beanFactoryReference=" + defaultFactory));
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"more then one beanFactory - default not possible to determine");
                    }
                    canUseDefaultBeanFactory = false;
                    defaultFactory = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (StringUtils.hasText((String)this.factoryName)) {
                Object[] aliases = this.beanFactory.getAliases(this.factoryName);
                for (String name : this.names = (String[])ObjectUtils.addObjectToArray((Object[])aliases, (Object)this.factoryName)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding key=" + name + " w/ reference=" + this.beanFactory));
                    }
                    if ((!beanFactories.containsKey(name) || this.beanFactory.equals(beanFactories.get(name))) && beanFactories.putIfAbsent(name, this.beanFactory) == null) continue;
                    throw new IllegalArgumentException("a beanFactoryReference already exists for key " + this.factoryName);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy() {
        if (this.names != null) {
            for (String name : this.names) {
                beanFactories.remove(name);
            }
        }
        if (this.beanFactory != defaultFactory) return;
        Class<GemfireBeanFactoryLocator> clazz = GemfireBeanFactoryLocator.class;
        synchronized (GemfireBeanFactoryLocator.class) {
            defaultFactory = null;
            canUseDefaultBeanFactory = beanFactories.isEmpty();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    public BeanFactoryReference useBeanFactory(String factoryKey) throws BeansException {
        BeanFactory factory;
        if (!StringUtils.hasText((String)factoryKey)) {
            if (!canUseDefaultBeanFactory) {
                throw new IllegalArgumentException("a non-null factoryKey needs to be specified as there are more then one factoryKeys available; " + beanFactories.keySet());
            }
            factory = defaultFactory;
        } else {
            factory = (BeanFactory)beanFactories.get(factoryKey);
            if (factory == null) {
                throw new IllegalArgumentException("there is no beanFactory under key " + factoryKey);
            }
        }
        return new SimpleBeanFactoryReference(factory);
    }

    public void setBeanName(String name) {
        this.factoryName = name;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private static class SimpleBeanFactoryReference
    implements BeanFactoryReference {
        private BeanFactory beanFactory;

        SimpleBeanFactoryReference(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public BeanFactory getFactory() {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"The BeanFactory has already been released or closed");
            return this.beanFactory;
        }

        public void release() throws FatalBeanException {
            this.beanFactory = null;
        }
    }
}

